% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/algorithms.R
\name{size_uniform}
\alias{size_uniform}
\title{SizeUniform Size Overlap Randomization Algorithm}
\usage{
size_uniform(speciesData = runif(20))
}
\arguments{
\item{speciesData}{a vector of positive real values representing the body
sizes or trait values for each species.}
}
\value{
Returns a vector of body sizes that have been randomly assigned. The
largest and smallest body sizes in the randomized assemblage match those in
the empirical data.
}
\description{
Function to randomize body sizes within a uniform distribution
with boundaries set by the largest and smallest species in the assemblage.
}
\details{
If the assemblage contains n species,
only the body sizes of the inner n - 2 species are randomized.
}
\note{
Although the distribution of body sizes may not be truly uniform,
it may be approximately uniform within the range of observed values,
particularly for small assemblages.
}
\examples{
nullSizes <-size_uniform(speciesData=runif(20))
}
\references{
Simberloff, D. and W. Boecklen. 1981. Santa Rosalia
reconsidered: size ratios and competition. Evolution 35: 1206-1228.

Tonkyn, D.W. and B.J. Cole. 1986. The statistical analysis of size ratios.
American Naturalist 128: 66-81.
}
\seealso{
\code{\link{size_gamma}} size distribution function.
}

