% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/metrics.R
\name{v_ratio}
\alias{v_ratio}
\title{SchlutersVRatio Co-occurrence Metric}
\usage{
v_ratio(m = matrix(rbinom(100, 1, 0.5), nrow = 10))
}
\arguments{
\item{m}{a binary presence-absence matrix in which rows are species and columns
are sites. The entries may be either abundances or occurrences of indivdual species.}
}
\value{
Returns the variance ratio of the matrix.
}
\description{
Takes a binary presence-absence matrix or a matrix of
abundances and returns Schluter's (1984) variance ratio.
}
\details{
The variance ratio is the ratio of the variance in species number
among sites to the sum of the variance of the species occurrences. If the average
covariation in abundance (or occurrence) of each species pair is close to zero,
the expected value for this ratio is approximately 1.0. V-ratios larger than 1.0
imply positive average covariation in the abundance of species pairs, whereas V-ratios
significantly smaller than 1.0 imply negative average covariation.
}
\note{
This index is determined exclusively by the row and column sums of the
matrix, so it cannot be used with null model algorithms that hold both of those
elements fixed. A simple randomization of the rows of the matrix (see sim2)
assumes that all sites are equiprobable, so it may generate large values (=
positive covariance) that reflect heterogeneity among sites.
}
\examples{
varCScore <- v_ratio(m=matrix(rbinom(100,1,0.5),nrow=10))
}
\references{
Schluter, D. 1984. A variance test for detecting species associations,
with some example applications. Ecology 65: 998-1005.

McCulloch, C.E. 1985. Variance tests for species association. Ecology 66: 1676-1681.
}

