% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getWeightJkReplicates.R
\name{getWeightJkReplicates}
\alias{getWeightJkReplicates}
\title{Return the jackknife replicate weights associated with a weight variable.}
\usage{
getWeightJkReplicates(var, data)
}
\arguments{
\item{var}{character indicating the name of the variable for which the
jackknife replicate weights are desired.}

\item{data}{an \code{edsurvey.data.frame} or \code{light.edsurvey.data.frame}.}
}
\value{
A character vector of the jackknife replicate weights.
}
\description{
Return the jackknife replicate weights on an \code{edsurvey.data.frame} or \code{light.edsurvey.data.frame} associated with a weight variable.
}
\examples{
# read in the example data (generated, not real student data)
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package = "NAEPprimer"))

getWeightJkReplicates(var="origwt", data=sdf)
}
\author{
Michael Lee and Paul Bailey
}
