% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EigenR.R
\name{Eigen_lsSolve}
\alias{Eigen_lsSolve}
\title{Linear least-squares problems}
\usage{
Eigen_lsSolve(A, b, method = "cod")
}
\arguments{
\item{A}{a \code{n*p} matrix, real or complex}

\item{b}{a vector of length \code{n} or a matrix with \code{n} rows, 
real or complex}

\item{method}{the method used to solve the problem, either \code{"svd"} 
(based on the SVD decomposition) or \code{"cod"} (based on the 
complete orthogonal decomposition)}
}
\value{
The solution \code{X} of the least-squares problem \code{AX ~= b} 
  (similar to \code{lm.fit(A, b)$coefficients}). This is a matrix if 
  \code{b} is a matrix, or a vector if \code{b} is a vector.
}
\description{
Solves a linear least-squares problem.
}
\examples{
set.seed(129)
n <- 7; p <- 2
A <- matrix(rnorm(n * p), n, p)
b <- rnorm(n)
lsfit <- Eigen_lsSolve(A, b)
b - A \%*\% lsfit # residuals
}
