% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{plotCalibration}
\alias{plotCalibration}
\title{Create a calibration plot}
\usage{
plotCalibration(logRr, seLogRr, useMcmc = FALSE, fileName = NULL)
}
\arguments{
\item{logRr}{A numeric vector of effect estimates on the log scale}

\item{seLogRr}{The standard error of the log of the effect estimates. Hint: often the standard
error = (log(<lower bound 95 percent confidence interval>) - log(<effect
estimate>))/qnorm(0.025)}

\item{useMcmc}{Use MCMC to estimate the calibrated P-value?}

\item{fileName}{Name of the file where the plot should be saved, for example 'plot.png'. See the
function \code{ggsave} in the ggplot2 package for supported file formats.}
}
\value{
A Ggplot object. Use the \code{ggsave} function to save to file.
}
\description{
\code{plotCalibration} creates a plot showing the calibration of our calibration procedure
}
\details{
Creates a calibration plot showing the number of effects with p < alpha for every level of alpha.
The empirical calibration is performed using a leave-one-out design: The p-value of an effect is
computed by fitting a null using all other negative controls. Ideally, the calibration line should
approximate the diagonal. The plot shows both theoretical (traditional) and empirically calibrated
p-values.
}
\examples{
data(sccs)
negatives <- sccs[sccs$groundTruth == 0, ]
plotCalibration(negatives$logRr, negatives$seLogRr)

}

