% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{plotMcmcTrace}
\alias{plotMcmcTrace}
\title{Plot the MCMC trace}
\usage{
plotMcmcTrace(mcmcNull, fileName = NULL)
}
\arguments{
\item{mcmcNull}{An object of type \code{mcmcNull} as generated using the \code{fitMcmcNull}
function.}

\item{fileName}{Name of the file where the plot should be saved, for example 'plot.png'. See the
function \code{ggsave} in the ggplot2 package for supported file formats.}
}
\description{
Plot the MCMC trace
}
\details{
Plot the trace of the MCMC for diagnostics purposes.
}
\examples{
data(sccs)
negatives <- sccs[sccs$groundTruth == 0, ]
null <- fitMcmcNull(negatives$logRr, negatives$seLogRr)
plotMcmcTrace(null)

}

