.Distribution.abb <-
c("beta", "binom", "cauchy", "chi", "chisq", "exp", "evd", "f", 
"gamma", "gammaAlt", "gevd", "geom", "hyper", "logis", "lnorm", 
"lnormAlt", "lnormMix", "lnormMixAlt", "lnorm3", "lnormTrunc", 
"lnormTruncAlt", "nbinom", "norm", "normMix", "normTrunc", "pareto", 
"pois", "t", "tri", "unif", "weibull", "wilcox", "zmlnorm", "zmlnormAlt", 
"zmnorm")
.Distribution.name <-
c("Beta", "Binomial", "Cauchy", "Chi", "Chi-square", "Exponential", 
"Extreme Value", "F", "Gamma", "Gamma", "Generalized Extreme Value", 
"Geometric", "Hypergeometric", "Logistic", "Lognormal", "Lognormal", 
"Lognormal Mixture", "Lognormal Mixture", "3-Parameter Lognormal", 
"Truncated Lognormal", "Truncated Lognormal", "Negative Binomial", 
"Normal", "Normal Mixture", "Truncated Normal", "Pareto", "Poisson", 
"Student's t", "Triangular", "Uniform", "Weibull", "Wilcoxon Rank Sum", 
"Zero-Modified Lognormal (Delta)", "Zero-Modified Lognormal (Delta)", 
"Zero-Modified Normal")
.Distribution.name.alt <-
c("Beta", "Binomial", "Cauchy", "Chi", "Chi-square", "Exponential", 
"Extreme Value", "F", "Gamma", "Gamma (Alternative)", "Generalized Extreme Value", 
"Geometric", "Hypergeometric", "Logistic", "Lognormal", "Lognormal (Alternative)", 
"Lognormal Mixture", "Lognormal Mixture (Alternative)", "3-Parameter Lognormal", 
"Truncated Lognormal", "Truncated Lognormal (Alternative)", "Negative Binomial", 
"Normal", "Normal Mixture", "Truncated Normal", "Pareto", "Poisson", 
"Student's t", "Triangular", "Uniform", "Weibull", "Wilcoxon Rank Sum", 
"Zero-Modified Lognormal (Delta)", "Zero-Modified Lognormal (Delta; Alternative)", 
"Zero-Modified Normal")
.Distribution.params.default.list <-
structure(list(beta = structure(c(1, 1, 0), .Names = c("shape1", 
"shape2", "ncp")), binom = structure(c(1, 0.5), .Names = c("size", 
"prob")), cauchy = structure(c(0, 1), .Names = c("location", 
"scale")), chi = structure(1, .Names = "df"), chisq = structure(c(1, 
0), .Names = c("df", "ncp")), exp = structure(1, .Names = "rate"), 
    evd = structure(c(0, 1), .Names = c("location", "scale")), 
    f = structure(c(1, 1, 0), .Names = c("df1", "df2", "ncp")), 
    gamma = structure(c(1, 1), .Names = c("shape", "scale")), 
    gammaAlt = structure(c(1, 1), .Names = c("mean", "cv")), 
    gevd = structure(c(0, 1, 0), .Names = c("location", "scale", 
    "shape")), geom = structure(0.5, .Names = "prob"), hyper = structure(c(10, 
    10, 5), .Names = c("m", "n", "k")), logis = structure(c(0, 
    1), .Names = c("location", "scale")), lnorm = structure(c(0, 
    1), .Names = c("meanlog", "sdlog")), lnormAlt = structure(c(1.64872127070013, 
    1.31083249443209), .Names = c("mean", "cv")), lnormMix = structure(c(0, 
    1, 0, 1, 0.5), .Names = c("meanlog1", "sdlog1", "meanlog2", 
    "sdlog2", "p.mix")), lnormMixAlt = structure(c(1.64872127070013, 
    1.31083249443209, 1.64872127070013, 1.31083249443209, 0.5
    ), .Names = c("mean1", "cv1", "mean2", "cv2", "p.mix")), 
    lnorm3 = structure(c(0, 1, 0), .Names = c("meanlog", "sdlog", 
    "threshold")), lnormTrunc = structure(c(0, 1, 0, Inf), .Names = c("meanlog", 
    "sdlog", "min", "max")), lnormTruncAlt = structure(c(1.64872127070013, 
    1.31083249443209, 0, Inf), .Names = c("mean", "cv", "min", 
    "max")), nbinom = structure(c(1, 0.5), .Names = c("size", 
    "prob")), norm = structure(c(0, 1), .Names = c("mean", "sd"
    )), normMix = structure(c(0, 1, 0, 1, 0.5), .Names = c("mean1", 
    "sd1", "mean2", "sd2", "p.mix")), normTrunc = structure(c(0, 
    1, -Inf, Inf), .Names = c("mean", "sd", "min", "max")), pareto = structure(c(1, 
    1), .Names = c("location", "shape")), pois = structure(1, .Names = "lambda"), 
    t = structure(c(1, 0), .Names = c("df", "ncp")), tri = structure(c(0, 
    1, 0.5), .Names = c("min", "max", "mode")), unif = structure(c(0, 
    1), .Names = c("min", "max")), weibull = structure(c(1, 1
    ), .Names = c("shape", "scale")), wilcox = structure(c(5, 
    5), .Names = c("m", "n")), zmlnorm = structure(c(0, 1, 0.5
    ), .Names = c("meanlog", "sdlog", "p.zero")), zmlnormAlt = structure(c(1.64872127070013, 
    1.31083249443209, 0.5), .Names = c("mean", "cv", "p.zero"
    )), zmnorm = structure(c(0, 1, 0.5), .Names = c("mean", "sd", 
    "p.zero"))), .Names = c("beta", "binom", "cauchy", "chi", 
"chisq", "exp", "evd", "f", "gamma", "gammaAlt", "gevd", "geom", 
"hyper", "logis", "lnorm", "lnormAlt", "lnormMix", "lnormMixAlt", 
"lnorm3", "lnormTrunc", "lnormTruncAlt", "nbinom", "norm", "normMix", 
"normTrunc", "pareto", "pois", "t", "tri", "unif", "weibull", 
"wilcox", "zmlnorm", "zmlnormAlt", "zmnorm"))
.Distribution.type <-
structure(c("Continuous", "Finite Discrete", "Continuous", "Continuous", 
"Continuous", "Continuous", "Continuous", "Continuous", "Continuous", 
"Continuous", "Continuous", "Discrete", "Finite Discrete", "Continuous", 
"Continuous", "Continuous", "Continuous", "Continuous", "Continuous", 
"Continuous", "Continuous", "Discrete", "Continuous", "Continuous", 
"Continuous", "Continuous", "Discrete", "Continuous", "Continuous", 
"Continuous", "Continuous", "Finite Discrete", "Mixed", "Mixed", 
"Mixed"), .Names = c("beta", "binom", "cauchy", "chi", "chisq", 
"exp", "evd", "f", "gamma", "gammaAlt", "gevd", "geom", "hyper", 
"logis", "lnorm", "lnormAlt", "lnormMix", "lnormMixAlt", "lnorm3", 
"lnormTrunc", "lnormTruncAlt", "nbinom", "norm", "normMix", "normTrunc", 
"pareto", "pois", "t", "tri", "unif", "weibull", "wilcox", "zmlnorm", 
"zmlnormAlt", "zmnorm"))
.Eulers.constant <-
0.577215664901533
.Gr.and.title.pars <-
c("adj", "ann", "ask", "axes", "bg", "bty", "cex", "cex.axis", 
"cex.lab", "cex.main", "cex.sub", "cin", "col", "col.axis", "col.lab", 
"col.main", "col.sub", "cra", "crt", "csi", "cxy", "din", "err", 
"family", "fg", "fig", "fin", "font", "font.axis", "font.lab", 
"font.main", "font.sub", "frame.plot", "lab", "las", "lend", 
"lheight", "ljoin", "lmitre", "log", "lty", "lwd", "mai", "main", 
"mar", "mex", "mfcol", "mfg", "mfrow", "mgp", "mkh", "new", "oma", 
"omd", "omi", "pch", "pin", "plt", "ps", "pty", "smo", "srt", 
"sub", "tck", "tcl", "type", "usr", "xaxp", "xaxs", "xaxt", "xlab", 
"xlim", "xlog", "xpd", "yaxp", "yaxs", "yaxt", "ylab", "ylim", 
"ylog")
.Gr.pars.general <-
c("adj", "ann", "ask", "bg", "bty", "cex", "cex.axis", "cex.lab", 
"cex.main", "cex.sub", "col", "col.axis", "col.lab", "col.main", 
"col.sub", "crt", "err", "family", "fg", "font", "font.axis", 
"font.lab", "font.main", "font.sub", "lab", "las", "lend", "lheight", 
"ljoin", "lmitre", "lty", "lwd", "mgp", "mkh", "pch", "ps", "smo", 
"srt", "tck", "xaxp", "xaxs", "xaxt", "xpd", "yaxp", "yaxs", 
"yaxt")
.Gr.pars.high <-
c("axes", "log", "xlog", "ylog", "type", "xlab", "xlim", "ylab", 
"ylim", "frame.plot")
.Gr.pars.high.and.title <-
c("axes", "log", "xlog", "ylog", "main", "sub", "type", "xlab", 
"xlim", "ylab", "ylim", "line", "outer", "frame.plot")
.Gr.pars.info <-
c("cin", "cra", "csi", "cxy", "din")
.Gr.pars.layout <-
c("ask", "fig", "fin", "lheight", "mai", "mar", "mex", "mfcol", 
"mfg", "mfrow", "new", "oma", "omd", "omi", "pin", "plt", "pty", 
"usr")
.ppcc.evd.gof.crit.val.mat <-
structure(c(156, 114, 99.2, 85.9, 73.7, 66.6, 57.2, 59.7, 53, 
48.3, 30.1, 22.5, 15.3, 8.23, 4.77, 3.23, 1.95, 1.12, 137, 94, 
80.9, 71.4, 61.1, 53.3, 49.4, 47.5, 44.6, 40.4, 23.7, 18.1, 12.2, 
6.66, 3.82, 2.61, 1.59, 0.858, 91.6, 61, 47.4, 40.6, 35.4, 31.5, 
28, 25.3, 23.6, 22.1, 13.4, 9.79, 6.67, 3.78, 2.09, 1.5, 0.975, 
0.525, 74, 48.3, 37.8, 31.1, 27.1, 24, 21.3, 19.6, 18.1, 16.9, 
10.2, 7.49, 5.01, 2.92, 1.61, 1.16, 0.756, 0.414, 49.6, 33.3, 
25.4, 21.4, 18.2, 16.1, 14.4, 13.1, 11.9, 11.2, 6.73, 4.91, 3.33, 
1.93, 1.09, 0.779, 0.507, 0.277, 32, 21.7, 16.9, 13.8, 12.1, 
10.6, 9.43, 8.61, 7.97, 7.39, 4.45, 3.23, 2.2, 1.28, 0.736, 0.528, 
0.344, 0.19), .Dim = c(18L, 6L), .Dimnames = list(c("10", "20", 
"30", "40", "50", "60", "70", "80", "90", "100", "200", "300", 
"500", "1000", "2000", "3000", "5000", "10000"), c("0.005", "0.01", 
"0.05", "0.10", "0.25", "0.50")))
.Random.seed <-
c(403L, 414L, -2029413987L, 316597962L, 1502200418L, 404440743L, 
-651576334L, 1346733883L, -2095205331L, 1709971357L, 404212565L, 
1092179070L, 1410905161L, 1501879534L, -173127324L, -674885036L, 
-1846341302L, -823294148L, -432129550L, -1861228588L, -1228961393L, 
-1714012261L, 226793852L, 374798333L, -1530319220L, -198374892L, 
-210002899L, -1065803628L, -1904706942L, 1079002318L, 1199212249L, 
1560163217L, -1716781725L, 1331787257L, 36369291L, -2084676187L, 
320492185L, 1010854332L, -57909105L, -1394645517L, 244185057L, 
-323835700L, 1757074654L, -941701570L, -1995485315L, -444123997L, 
-1369892063L, -755676691L, -8920811L, 1149302974L, 755613528L, 
-1312414654L, 253440923L, 732548946L, 713296321L, -63670560L, 
-2055785870L, 1572135722L, 151070631L, -971843768L, -941969167L, 
-1097319262L, 1694865113L, 380984343L, -681839326L, 123776379L, 
1638612665L, 750695664L, -1605203241L, -1860223404L, 1083014194L, 
259149020L, -922935697L, -1989186387L, -285714930L, 671797833L, 
1428733792L, 942403708L, 1268248354L, -183218356L, -1714598279L, 
1448083938L, 845621077L, 637410131L, -330015928L, -1851104214L, 
-1743242127L, 1642637041L, 5910195L, 1933763879L, 1404501586L, 
758953438L, -1730398082L, 1396652145L, -1795693244L, 773560817L, 
1591635623L, -1956271026L, -121605933L, -1364465951L, -1545072886L, 
1210139633L, -852540406L, 825713650L, 2123681490L, -780349156L, 
-1726558803L, 1395057329L, -1754861831L, -1671773484L, 1980931538L, 
1903598941L, -1626325619L, 1963665552L, -1528303319L, -141416678L, 
-782555528L, -634988225L, 476244373L, 240385891L, 1355276543L, 
885135069L, 899238590L, 1045054013L, -1831228582L, -1655589250L, 
-1407325431L, 19442796L, 1225024044L, -169179160L, -1864566946L, 
23709024L, 818816571L, -1452426355L, -1805692898L, -374733758L, 
-713227415L, 2028929498L, -38466100L, -638523766L, -2008677916L, 
654762125L, -87785319L, 1276031765L, -1777627028L, 1328471124L, 
-724066559L, 2088843230L, 481610303L, 107272722L, -593536959L, 
448475341L, 882452618L, 1280911795L, 2109973618L, -1279034584L, 
-1062282309L, 1840691653L, 1881862786L, 529778608L, -2119520930L, 
-183421231L, -2038310453L, -749240907L, -1572399210L, -1116628060L, 
1923327310L, -1445896919L, -852702397L, 1150146336L, 344318842L, 
-282058781L, -2085548088L, 483640783L, -397306476L, -1138183284L, 
-943557103L, -175989497L, -2033924324L, 785446432L, -1785413289L, 
287069881L, 305423296L, 640637812L, 1734955047L, 1633181092L, 
-1313763642L, 355114668L, -1079152073L, 2130231012L, -893200996L, 
-400078426L, 422072668L, 551370517L, 294573827L, 1715238405L, 
-957151694L, -47847033L, -1762571392L, 1756787343L, 1104740244L, 
-1658083539L, 1282207380L, -980549327L, 559485116L, -1245689222L, 
1960595807L, -1926931317L, 840317159L, 47285411L, -118924292L, 
161626071L, -973142875L, -420483281L, 1349094184L, -587055899L, 
642063260L, -914698235L, 1686762407L, -1611017007L, -864404812L, 
333877981L, 817222480L, -1688159903L, 850350947L, -1411842156L, 
-489845190L, 1527675437L, -342574299L, -1572675667L, 1325203153L, 
468913869L, 1588824554L, -1170877607L, 442884152L, -1173081347L, 
-607962557L, -378253002L, -1706309611L, 973256265L, 1881077985L, 
-1404222988L, -1534250610L, -1101622669L, -966662186L, -1173352552L, 
-885128804L, -1362817133L, -1345449208L, 922177070L, -298267859L, 
-2063139019L, 2040298787L, 1960373637L, -2040249540L, -1158851537L, 
1385854983L, 1048610651L, -1832283604L, 1136011263L, 1664014468L, 
1407734489L, 1646089553L, 2119792665L, -1383656158L, -1410286625L, 
1216463865L, 1829670272L, -79199920L, -1855012464L, 1435359460L, 
-1781370669L, -1184883441L, -604556504L, -337704892L, 855804984L, 
1199497483L, -1237858608L, -1135342051L, 1118347388L, 582305912L, 
311178731L, -1701066644L, 1172021992L, 9559574L, 145469267L, 
745187935L, -2062708845L, -1979974168L, 1543727231L, 868760805L, 
-1357784686L, -1583363538L, -662093284L, -905124589L, -1673819400L, 
1234441016L, -856508560L, 205901777L, -1954696725L, -1851766323L, 
612875302L, 1127662334L, -1308384403L, 769098661L, 13066260L, 
-1806560171L, 1720725562L, -226520186L, 439150714L, -1888564696L, 
194066476L, -1053799141L, -2004637378L, -875359281L, -2107235791L, 
2035123086L, 291788400L, -521497593L, -833170564L, -1880389381L, 
-2037294843L, -148363501L, 17850524L, -394516757L, -2013805187L, 
93363286L, 207388027L, -469682337L, -525427645L, -1373683182L, 
898675848L, -1369202566L, 2042335656L, -2009577049L, 1559710049L, 
-1941385811L, -112123995L, 1490902661L, 537081148L, -701169721L, 
-1411449231L, 2113883017L, -1859961812L, -1113316643L, 2008823878L, 
-82612610L, 169237496L, 1307790686L, -622211061L, 1668125057L, 
2021056817L, -972336579L, 1389236715L, 475677497L, 715946553L, 
958369945L, 2035647754L, -502218389L, 2028461220L, -1974850510L, 
-1276050997L, -527462835L, 1989824904L, -1447913317L, -771227072L, 
1524503061L, -1178414578L, 757609232L, 1312322989L, -1034564839L, 
-964483968L, 1896522510L, 390458881L, 470757763L, 908802329L, 
720003157L, -43155074L, 1985409225L, -1014950675L, 132883197L, 
983817689L, 1859749342L, 183821219L, 724518870L, 404536784L, 
1965117350L, -1073733746L, -519242194L, 2145227520L, 1546773472L, 
-554419942L, 635585978L, -207713661L, -318303739L, -1908335612L, 
-1215611843L, 1650225186L, 979075704L, -182774048L, -2082633211L, 
1094589353L, 867121521L, 801413733L, -1354904845L, 789912823L, 
1126547379L, 1412234288L, -1745209940L, -132115301L, 262776907L, 
-1554909307L, 1881354864L, -1217941474L, 907856226L, -897113571L, 
-1573755883L, 1064850495L, -286455426L, 1807054710L, 1609639424L, 
1041312867L, 426099919L, 894620574L, -1577300496L, -129338692L, 
1185503169L, 1773129259L, -1842443207L, -1895676333L, -30681612L, 
1033855923L, 91875787L, 1262693880L, 206740422L, 1571354371L, 
-900282118L, 84215562L, -206501978L, 1272384073L, 675738969L, 
2067659652L, -765109857L, 690396603L, -2049692113L, -428832567L, 
-189790616L, 1623788845L, 1815814733L, -1690617129L, 1149902165L, 
608639642L, 1532942769L, 325453786L, -1828408141L, -322684066L, 
1167189822L, 761902049L, -1778723617L, 1884060990L, -972811586L, 
792389033L, 653287270L, 1534806780L, -1526632354L, -205977604L, 
-148706269L, -501557020L, -1297059596L, 171636554L, -98803057L, 
154284096L, -1180948573L, -1099135362L, 1848518674L, -1464256963L, 
1557087868L, 165736158L, 902054613L, 1136726451L, -1168801173L, 
-1385571134L, -2014328019L, -303654834L, -385036562L, 300836667L, 
-724710627L, -746107871L, 1060810769L, 2062208983L, -1678346846L, 
1527200011L, 2045513611L, -1224228306L, -1436519418L, 16516482L, 
1176945765L, 1044139192L, 1277163106L, -1753779550L, 1820397041L, 
-1326796557L, -769840156L, 518680562L, 1221587483L, -1400435767L, 
-801212544L, 245429778L, -1367207376L, 1049477577L, -1291465746L, 
1210957942L, -1935431524L, 1538122451L, 833055551L, -1911308156L, 
-1767216797L, 1739544215L, -1841903850L, -299082223L, -595532752L, 
1530061012L, 1907805532L, -1348812343L, -1564527208L, 416449650L, 
-170721359L, -1223025061L, 645239957L, 1379431091L, -1164530640L, 
-1065774037L, -257087493L, -1594654873L, -961904717L, -507866027L, 
1452585874L, 421359630L, -1342445787L, -2013326785L, 1482399107L, 
-538317750L, -1384813299L, 284288738L, 1814679818L, 1727792385L, 
1547613617L, 781001077L, 451746476L, 1018517333L, -1185451701L, 
-2133391815L, 1192971758L, 440662701L, -1500112573L, 1555753041L, 
-366637010L, -822002564L, 2128814649L, -2028559825L, 429180583L, 
-351526295L, 218134833L, -1704659360L, 1658741529L, 632660617L, 
-1581355407L, -526316713L, -443362269L, 834710861L, -695476077L, 
-1485664149L, -1873077204L, 1866243848L, 440863804L, -2059435736L, 
543691478L, -2065219817L, -275413732L, 880752935L, -1227101732L, 
-609147190L, 930228270L, 557206528L, -1148525345L, 7623483L, 
793461733L, 751725788L, -1231265997L, 1151534710L, 731616326L, 
1547694433L, 534581605L, 1170408347L, 1477462081L, -72053087L, 
-1877472026L, 482812637L, -1066922846L, -328547668L, -509908959L, 
-2128441684L, 1200724115L, 934060285L, -1822508855L, -878787619L, 
-1259303168L, -957313065L, 647499458L, -1047977425L, -1996198589L, 
-1272138806L, -580397326L, -820757364L, 700856899L, 203414489L, 
-82743358L, 1976327719L, -942552476L, -1503652456L, 380050921L, 
1871954941L, -1268694568L, 1224101363L, -1494999180L, -1596457367L
)
.rank.von.neumann.dist.mat.10 <-
structure(c(0.109090909090909, 0.145454545454545, 0.181818181818182, 
0.206060606060606, 0.218181818181818, 0.242424242424242, 0.254545454545455, 
0.278787878787879, 0.290909090909091, 0.303030303030303, 0.315151515151515, 
0.327272727272727, 0.339393939393939, 0.351515151515152, 0.363636363636364, 
0.375757575757576, 0.387878787878788, 0.4, 0.412121212121212, 
0.424242424242424, 0.436363636363636, 0.448484848484848, 0.460606060606061, 
0.472727272727273, 0.484848484848485, 0.496969696969697, 0.509090909090909, 
0.521212121212121, 0.533333333333333, 0.545454545454545, 0.557575757575758, 
0.56969696969697, 0.581818181818182, 0.593939393939394, 0.606060606060606, 
0.618181818181818, 0.63030303030303, 0.642424242424242, 0.654545454545455, 
0.666666666666667, 0.678787878787879, 0.690909090909091, 0.703030303030303, 
0.715151515151515, 0.727272727272727, 0.739393939393939, 0.751515151515151, 
0.763636363636364, 0.775757575757576, 0.787878787878788, 0.8, 
0.812121212121212, 0.824242424242424, 0.836363636363636, 0.848484848484849, 
0.860606060606061, 0.872727272727273, 0.884848484848485, 0.896969696969697, 
0.909090909090909, 0.921212121212121, 0.933333333333333, 0.945454545454545, 
0.957575757575758, 0.96969696969697, 0.981818181818182, 0.993939393939394, 
1.00606060606061, 1.01818181818182, 1.03030303030303, 1.04242424242424, 
1.05454545454545, 1.06666666666667, 1.07878787878788, 1.09090909090909, 
1.1030303030303, 1.11515151515152, 1.12727272727273, 1.13939393939394, 
1.15151515151515, 1.16363636363636, 1.17575757575758, 1.18787878787879, 
1.2, 1.21212121212121, 1.22424242424242, 1.23636363636364, 1.24848484848485, 
1.26060606060606, 1.27272727272727, 1.28484848484848, 1.2969696969697, 
1.30909090909091, 1.32121212121212, 1.33333333333333, 1.34545454545455, 
1.35757575757576, 1.36969696969697, 1.38181818181818, 1.39393939393939, 
1.40606060606061, 1.41818181818182, 1.43030303030303, 1.44242424242424, 
1.45454545454545, 1.46666666666667, 1.47878787878788, 1.49090909090909, 
1.5030303030303, 1.51515151515151, 1.52727272727273, 1.53939393939394, 
1.55151515151515, 1.56363636363636, 1.57575757575758, 1.58787878787879, 
1.6, 1.61212121212121, 1.62424242424242, 1.63636363636364, 1.64848484848485, 
1.66060606060606, 1.67272727272727, 1.68484848484849, 1.6969696969697, 
1.70909090909091, 1.72121212121212, 1.73333333333333, 1.74545454545454, 
1.75757575757576, 1.76969696969697, 1.78181818181818, 1.79393939393939, 
1.80606060606061, 1.81818181818182, 1.83030303030303, 1.84242424242424, 
1.85454545454545, 1.86666666666667, 1.87878787878788, 1.89090909090909, 
1.9030303030303, 1.91515151515152, 1.92727272727273, 1.93939393939394, 
1.95151515151515, 1.96363636363636, 1.97575757575758, 1.98787878787879, 
2, 2.01212121212121, 2.02424242424242, 2.03636363636364, 2.04848484848485, 
2.06060606060606, 2.07272727272727, 2.08484848484849, 2.0969696969697, 
2.10909090909091, 2.12121212121212, 2.13333333333333, 2.14545454545455, 
2.15757575757576, 2.16969696969697, 2.18181818181818, 2.19393939393939, 
2.20606060606061, 2.21818181818182, 2.23030303030303, 2.24242424242424, 
2.25454545454545, 2.26666666666667, 2.27878787878788, 2.29090909090909, 
2.3030303030303, 2.31515151515152, 2.32727272727273, 2.33939393939394, 
2.35151515151515, 2.36363636363636, 2.37575757575758, 2.38787878787879, 
2.4, 2.41212121212121, 2.42424242424242, 2.43636363636364, 2.44848484848485, 
2.46060606060606, 2.47272727272727, 2.48484848484848, 2.4969696969697, 
2.50909090909091, 2.52121212121212, 2.53333333333333, 2.54545454545455, 
2.55757575757576, 2.56969696969697, 2.58181818181818, 2.59393939393939, 
2.60606060606061, 2.61818181818182, 2.63030303030303, 2.64242424242424, 
2.65454545454546, 2.66666666666667, 2.67878787878788, 2.69090909090909, 
2.7030303030303, 2.71515151515152, 2.72727272727273, 2.73939393939394, 
2.75151515151515, 2.76363636363636, 2.77575757575758, 2.78787878787879, 
2.8, 2.81212121212121, 2.82424242424242, 2.83636363636364, 2.84848484848485, 
2.86060606060606, 2.87272727272727, 2.88484848484849, 2.8969696969697, 
2.90909090909091, 2.92121212121212, 2.93333333333333, 2.94545454545455, 
2.95757575757576, 2.96969696969697, 2.98181818181818, 2.99393939393939, 
3.00606060606061, 3.01818181818182, 3.03030303030303, 3.04242424242424, 
3.05454545454545, 3.06666666666667, 3.07878787878788, 3.09090909090909, 
3.1030303030303, 3.11515151515151, 3.12727272727273, 3.13939393939394, 
3.15151515151515, 3.16363636363636, 3.17575757575758, 3.18787878787879, 
3.2, 3.21212121212121, 3.22424242424242, 3.23636363636364, 3.24848484848485, 
3.26060606060606, 3.27272727272727, 3.28484848484848, 3.2969696969697, 
3.30909090909091, 3.32121212121212, 3.33333333333333, 3.34545454545454, 
3.35757575757576, 3.36969696969697, 3.38181818181818, 3.39393939393939, 
3.40606060606061, 3.41818181818182, 3.43030303030303, 3.44242424242424, 
3.45454545454545, 3.46666666666667, 3.47878787878788, 3.49090909090909, 
3.5030303030303, 3.51515151515152, 3.52727272727273, 3.53939393939394, 
3.55151515151515, 3.56363636363636, 3.57575757575758, 3.58787878787879, 
3.6, 3.61212121212121, 3.62424242424242, 3.63636363636364, 3.64848484848485, 
3.66060606060606, 3.67272727272727, 3.68484848484849, 3.6969696969697, 
3.70909090909091, 3.72121212121212, 3.73333333333333, 3.74545454545455, 
3.75757575757576, 3.76969696969697, 3.78181818181818, 3.79393939393939, 
3.80606060606061, 3.81818181818182, 3.83030303030303, 3.84242424242424, 
3.85454545454545, 3.86666666666667, 3.89090909090909, 5.51146384479718e-07, 
1.10229276895944e-06, 5.51146384479718e-06, 1.10229276895944e-06, 
7.71604938271605e-06, 5.51146384479718e-06, 1.43298059964727e-05, 
2.36992945326279e-05, 1.32275132275132e-05, 6.0626102292769e-06, 
4.51940035273369e-05, 1.48809523809524e-05, 1.98412698412698e-05, 
7.05467372134039e-05, 2.42504409171076e-05, 7.16490299823633e-05, 
6.39329805996473e-05, 6.00749559082892e-05, 0.000127865961199295, 
7.49559082892416e-05, 0.000124559082892416, 0.000119047619047619, 
0.000141093474426808, 0.000229828042328042, 6.8342151675485e-05, 
0.000297619047619048, 0.00019620811287478, 0.000193452380952381, 
0.000298721340388007, 0.000265652557319224, 0.000309744268077601, 
0.000434303350970018, 0.000252425044091711, 0.000479497354497354, 
0.000485008818342152, 0.000439814814814815, 0.000382495590828924, 
0.000639880952380952, 0.000541225749559083, 0.000618386243386243, 
0.000574294532627866, 0.000734678130511464, 0.000688932980599647, 
0.000814594356261023, 0.000636022927689594, 0.00110449735449735, 
0.00082120811287478, 0.00106205908289242, 0.000690035273368607, 
0.00140817901234568, 0.00113095238095238, 0.000950176366843034, 
0.0012092151675485, 0.00139440035273369, 0.00119157848324515, 
0.00170579805996473, 0.000921516754850088, 0.00182760141093474, 
0.00172729276895944, 0.00127259700176367, 0.0016060405643739, 
0.00220789241622575, 0.00146715167548501, 0.00214561287477954, 
0.00155753968253968, 0.00247409611992945, 0.00204254850088183, 
0.00224647266313933, 0.00185956790123457, 0.00269124779541446, 
0.00238977072310406, 0.00254850088183422, 0.00215718694885362, 
0.00366953262786596, 0.00228505291005291, 0.0027744708994709, 
0.00278549382716049, 0.00320546737213404, 0.00296075837742504, 
0.00341876102292769, 0.00242614638447972, 0.00411871693121693, 
0.00327601410934744, 0.00326278659611993, 0.00319334215167549, 
0.00468419312169312, 0.00323412698412698, 0.00426973104056437, 
0.00340718694885362, 0.00486166225749559, 0.00407517636684303, 
0.00430665784832452, 0.00377645502645503, 0.00562830687830688, 
0.00420304232804233, 0.00468143738977072, 0.00390652557319224, 
0.0062147266313933, 0.00436067019400353, 0.00482032627865961, 
0.00485559964726631, 0.00566192680776014, 0.00486331569664903, 
0.00586860670194003, 0.00430004409171076, 0.00750716490299824, 
0.00524691358024691, 0.00533564814814815, 0.00530753968253968, 
0.00710427689594356, 0.00542217813051146, 0.00655092592592593, 
0.00543430335097002, 0.00767636684303351, 0.00565035273368607, 
0.00661044973544974, 0.00562279541446208, 0.00780864197530864, 
0.0061739417989418, 0.00639825837742504, 0.00580246913580247, 
0.00867504409171076, 0.00586089065255732, 0.00711750440917108, 
0.00662918871252205, 0.00795855379188713, 0.0066468253968254, 
0.00798500881834215, 0.00591159611992945, 0.00934138007054674, 
0.0066358024691358, 0.00719356261022928, 0.00703483245149912, 
0.00887400793650794, 0.00629298941798942, 0.00812996031746032, 
0.00680224867724868, 0.00891920194003527, 0.00755511463844797, 
0.00777943121693122, 0.00661706349206349, 0.00945987654320988, 
0.00687389770723104, 0.00767636684303351, 0.00701829805996473, 
0.00993992504409171, 0.00649360670194003, 0.00807429453262787, 
0.00725418871252205, 0.00896604938271605, 0.00742173721340388, 
0.00838844797178131, 0.00646384479717813, 0.010041335978836, 
0.00673059964726631, 0.00758267195767196, 0.0075352733686067, 
0.00901565255731922, 0.00687940917107584, 0.00790399029982363, 
0.0069047619047619, 0.00869874338624339, 0.00682760141093475, 
0.00782242063492064, 0.00672508818342152, 0.00908013668430335, 
0.00642085537918871, 0.00740520282186949, 0.00675154320987654, 
0.0089456569664903, 0.00640983245149912, 0.00773148148148148, 
0.0067526455026455, 0.00813932980599647, 0.00619268077601411, 
0.00712191358024691, 0.00603946208112875, 0.00856591710758377, 
0.00604387125220458, 0.00641258818342152, 0.00622464726631393, 
0.00739087301587302, 0.00555335097001764, 0.00670194003527337, 
0.00579365079365079, 0.00769620811287478, 0.00535824514991182, 
0.00609347442680776, 0.00541887125220459, 0.00706128747795414, 
0.00537588183421517, 0.00566743827160494, 0.00513558201058201, 
0.00713789682539683, 0.00444885361552028, 0.00565696649029982, 
0.00489748677248677, 0.00575121252204586, 0.00465828924162257, 
0.00487103174603175, 0.00431327160493827, 0.00600198412698413, 
0.00390432098765432, 0.00468143738977072, 0.00446979717813051, 
0.00529210758377425, 0.0035626102292769, 0.00445546737213404, 
0.00364197530864197, 0.00469411375661376, 0.00368496472663139, 
0.00395006613756614, 0.0033939594356261, 0.00456845238095238, 
0.00301477072310406, 0.00346450617283951, 0.00335427689594356, 
0.00400738536155203, 0.00271935626102293, 0.00315972222222222, 
0.00275903880070547, 0.00352292768959436, 0.00257826278659612, 
0.00285383597883598, 0.00242724867724868, 0.00327491181657848, 
0.00224757495590829, 0.00241402116402116, 0.00222993827160494, 
0.00284336419753086, 0.00195546737213404, 0.00223324514991182, 
0.00201829805996473, 0.00247189153439153, 0.00167879188712522, 
0.0018777557319224, 0.00164572310405644, 0.00215939153439153, 
0.00146053791887125, 0.00163745590828924, 0.00136353615520282, 
0.00181768077601411, 0.00115189594356261, 0.0014103835978836, 
0.00117614638447972, 0.0015299823633157, 0.00102292768959436, 
0.00122574955908289, 0.00103174603174603, 0.00134424603174603, 
0.000805776014109347, 0.000952932098765432, 0.000846560846560847, 
0.00100198412698413, 0.000632716049382716, 0.000785934744268078, 
0.000596340388007055, 0.000882385361552028, 0.000630511463844797, 
0.000619488536155203, 0.000453042328042328, 0.000693893298059965, 
0.000389109347442681, 0.000460758377425044, 0.000430996472663139, 
0.000569885361552028, 0.000319664902998236, 0.0003913139329806, 
0.000309744268077601, 0.000413359788359788, 0.000264550264550265, 
0.000277226631393298, 0.00019620811287478, 0.000329585537918871, 
0.000147707231040564, 0.000246362433862434, 0.000147707231040564, 
0.000187389770723104, 0.000121252204585538, 0.000164241622574956, 
0.000127865961199295, 0.000150462962962963, 6.61375661375661e-05, 
0.000119047619047619, 5.73192239858907e-05, 0.000105820105820106, 
3.74779541446208e-05, 5.89726631393298e-05, 3.19664902998236e-05, 
6.22795414462081e-05, 3.85802469135802e-05, 3.47222222222222e-05, 
1.7636684303351e-05, 4.62962962962963e-05, 1.10229276895944e-05, 
1.87389770723104e-05, 6.61375661375661e-06, 1.43298059964727e-05, 
5.51146384479718e-06, 5.51146384479718e-06, 5.51146384479718e-06, 
4.40917107583774e-06, 1.10229276895944e-06, 3.30687830687831e-06, 
5.51146384479718e-07, 5.51146384479718e-07, 1.65343915343915e-06, 
7.16490299823633e-06, 8.26719576719577e-06, 1.59832451499118e-05, 
2.1494708994709e-05, 3.58245149911817e-05, 5.95238095238095e-05, 
7.27513227513227e-05, 7.88139329805996e-05, 0.000124007936507937, 
0.000138888888888889, 0.000158730158730159, 0.000229276895943563, 
0.00025352733686067, 0.000325176366843034, 0.000389109347442681, 
0.00044918430335097, 0.000577050264550265, 0.000652006172839506, 
0.000776565255731922, 0.000895612874779541, 0.00103670634920635, 
0.00126653439153439, 0.00133487654320988, 0.00163249559082892, 
0.0018287037037037, 0.00202215608465608, 0.00232087742504409, 
0.00258652998236332, 0.00289627425044092, 0.00333057760141093, 
0.00358300264550265, 0.0040625, 0.00454750881834215, 0.00498732363315697, 
0.00536981922398589, 0.00600970017636684, 0.00655092592592593, 
0.00716931216931217, 0.00774360670194003, 0.0084782848324515, 
0.00916721781305115, 0.00998181216931217, 0.0106178350970018, 
0.0117223324514991, 0.0125435405643739, 0.0136055996472663, 0.0142956349206349, 
0.0157038139329806, 0.016834766313933, 0.017784942680776, 0.0189941578483245, 
0.0203885582010582, 0.0215801366843034, 0.0232859347442681, 0.0242074514991182, 
0.0260350529100529, 0.0277623456790123, 0.029034942680776, 0.0306409832451499, 
0.0328488756613757, 0.0343160273368607, 0.0364616402116402, 0.0380191798941799, 
0.0404932760141093, 0.0425358245149912, 0.0447822971781305, 0.0466418650793651, 
0.0493331128747795, 0.0517228835978836, 0.0542713844797178, 0.0564285714285714, 
0.0600981040564374, 0.0623831569664903, 0.0651576278659612, 0.0679431216931217, 
0.0711485890652557, 0.0741093474426808, 0.0775281084656085, 0.0799542548500882, 
0.0840729717813051, 0.0873489858906525, 0.0906117724867725, 0.093805114638448, 
0.0984893077601411, 0.101723434744268, 0.105993165784832, 0.109400352733686, 
0.114262014991182, 0.118337191358025, 0.122643849206349, 0.126420304232804, 
0.132048611111111, 0.136251653439153, 0.140933090828924, 0.144839616402116, 
0.15105434303351, 0.155415013227513, 0.160235339506173, 0.165090939153439, 
0.170752865961199, 0.175616181657848, 0.181484788359788, 0.185784832451499, 
0.193291997354497, 0.198538910934744, 0.203874559082892, 0.209182098765432, 
0.216286375661376, 0.221708553791887, 0.228259479717813, 0.233693783068783, 
0.241370149911817, 0.247020502645503, 0.253630952380952, 0.259253747795414, 
0.267062389770723, 0.273236331569665, 0.27963458994709, 0.285437059082892, 
0.294112103174603, 0.29997299382716, 0.307090498236332, 0.313719686948854, 
0.321678240740741, 0.328325066137566, 0.336310074955908, 0.342221671075838, 
0.351563051146384, 0.35819885361552, 0.36539241622575, 0.372427248677249, 
0.381301256613757, 0.387594246031746, 0.395724206349206, 0.402526455026455, 
0.41144565696649, 0.419000771604938, 0.426780202821869, 0.433397266313933, 
0.442857142857143, 0.449731040564374, 0.457407407407407, 0.464425705467372, 
0.474365630511464, 0.480859237213404, 0.488933531746032, 0.496187720458554, 
0.50515376984127, 0.512575507054674, 0.520963955026455, 0.527427799823633, 
0.537469135802469, 0.544199735449735, 0.551782407407407, 0.559317680776014, 
0.568333333333333, 0.575212742504409, 0.583116732804232, 0.590021494708994, 
0.598720238095238, 0.605547839506173, 0.613370260141093, 0.620095348324515, 
0.629175485008818, 0.635596340388007, 0.643001543209876, 0.649753086419753, 
0.658698743386243, 0.665108575837742, 0.672840057319224, 0.679592702821869, 
0.687732032627866, 0.69392471340388, 0.701046626984127, 0.707086089065256, 
0.715652006172839, 0.721695877425044, 0.728108465608465, 0.734333112874779, 
0.741723985890652, 0.74727733686067, 0.753979276895943, 0.759772927689594, 
0.767469135802469, 0.772827380952381, 0.778920855379188, 0.784339726631393, 
0.791401014109347, 0.796776895943562, 0.802444334215167, 0.807579916225749, 
0.814717813051146, 0.819166666666666, 0.824823633156966, 0.829721119929453, 
0.835472332451499, 0.840130621693121, 0.845001653439153, 0.849314925044091, 
0.855316909171076, 0.85922123015873, 0.863902667548501, 0.868372464726631, 
0.873664572310405, 0.877227182539682, 0.881682649911816, 0.885324625220458, 
0.890018738977072, 0.893703703703703, 0.89765376984127, 0.901047729276896, 
0.905616181657848, 0.908630952380952, 0.912095458553792, 0.915449735449735, 
0.919457120811287, 0.92217647707231, 0.925336199294532, 0.928095238095238, 
0.931618165784832, 0.934196428571428, 0.937050264550264, 0.939477513227513, 
0.942752425044092, 0.945, 0.947414021164021, 0.949643959435626, 
0.952487323633157, 0.954442791005291, 0.956676036155203, 0.958694334215167, 
0.961166225749559, 0.962845017636684, 0.964722773368606, 0.966368496472663, 
0.968527888007054, 0.969988425925926, 0.971625881834215, 0.972989417989418, 
0.974807098765432, 0.975958994708994, 0.977369378306878, 0.978545524691358, 
0.980075507054673, 0.981098434744268, 0.982324184303351, 0.983355930335097, 
0.984700176366843, 0.985505952380952, 0.986458884479717, 0.987305445326278, 
0.988307429453262, 0.988940145502645, 0.989726080246913, 0.99032242063492, 
0.991204805996472, 0.991835317460317, 0.992454805996472, 0.992907848324515, 
0.993601741622575, 0.993990850970017, 0.994451609347442, 0.994882605820105, 
0.995452491181657, 0.995772156084656, 0.996163470017636, 0.996473214285714, 
0.996886574074074, 0.997151124338624, 0.997428350970017, 0.997624559082892, 
0.997954144620811, 0.998101851851852, 0.998348214285714, 0.998495921516754, 
0.998683311287478, 0.998804563492063, 0.998968805114638, 0.999096671075837, 
0.9992471340388, 0.999313271604938, 0.999432319223986, 0.999489638447971, 
0.999595458553792, 0.999632936507936, 0.999691909171076, 0.999723875661375, 
0.999786155202822, 0.999824735449735, 0.999859457671957, 0.999877094356261, 
0.999923390652557, 0.999934413580247, 0.999953152557319, 0.999959766313933, 
0.999974096119929, 0.999979607583774, 0.999985119047619, 0.999990630511463, 
0.999995039682539, 0.999996141975308, 0.999999448853615, 0.999999999999999
), .Dim = c(305L, 3L), .Dimnames = list(NULL, c("Order.Statistics", 
"Densities", "Cumulative.Probabilities")))
.rank.von.neumann.dist.mat.3 <-
structure(c(1, 2.5, 0.333333333333333, 0.666666666666667, 0.333333333333333, 
1), .Dim = 2:3, .Dimnames = list(NULL, c("Order.Statistics", 
"Densities", "Cumulative.Probabilities")))
.rank.von.neumann.dist.mat.4 <-
structure(c(0.6, 1.2, 1.8, 2.2, 2.8, 3.4, 0.0833333333333333, 
0.166666666666667, 0.25, 0.25, 0.166666666666667, 0.0833333333333333, 
0.0833333333333333, 0.25, 0.5, 0.75, 0.916666666666667, 1), .Dim = c(6L, 
3L), .Dimnames = list(NULL, c("Order.Statistics", "Densities", 
"Cumulative.Probabilities")))
.rank.von.neumann.dist.mat.5 <-
structure(c(0.4, 0.7, 1, 1.2, 1.3, 1.5, 1.8, 1.9, 2, 2.1, 2.2, 
2.3, 2.5, 2.6, 2.7, 3, 3.3, 3.5, 0.0166666666666667, 0.0333333333333333, 
0.0833333333333333, 0.0333333333333333, 0.0333333333333333, 0.166666666666667, 
0.0333333333333333, 0.0666666666666667, 0.05, 0.0333333333333333, 
0.0666666666666667, 0.0666666666666667, 0.1, 0.05, 0.0333333333333333, 
0.0666666666666667, 0.0333333333333333, 0.0333333333333333, 0.0166666666666667, 
0.05, 0.133333333333333, 0.166666666666667, 0.2, 0.366666666666667, 
0.4, 0.466666666666667, 0.516666666666667, 0.55, 0.616666666666667, 
0.683333333333333, 0.783333333333333, 0.833333333333333, 0.866666666666667, 
0.933333333333333, 0.966666666666667, 1), .Dim = c(18L, 3L), .Dimnames = list(
    NULL, c("Order.Statistics", "Densities", "Cumulative.Probabilities"
    )))
.rank.von.neumann.dist.mat.6 <-
structure(c(0.285714285714286, 0.457142857142857, 0.628571428571429, 
0.742857142857143, 0.8, 0.914285714285714, 0.971428571428571, 
1.08571428571429, 1.14285714285714, 1.2, 1.25714285714286, 1.31428571428571, 
1.37142857142857, 1.42857142857143, 1.48571428571429, 1.54285714285714, 
1.6, 1.65714285714286, 1.71428571428571, 1.77142857142857, 1.82857142857143, 
1.94285714285714, 2, 2.05714285714286, 2.11428571428571, 2.17142857142857, 
2.22857142857143, 2.28571428571429, 2.34285714285714, 2.4, 2.45714285714286, 
2.51428571428571, 2.57142857142857, 2.62857142857143, 2.68571428571429, 
2.74285714285714, 2.8, 2.85714285714286, 2.91428571428571, 2.97142857142857, 
3.02857142857143, 3.08571428571429, 3.14285714285714, 3.2, 3.37142857142857, 
3.42857142857143, 3.54285714285714, 3.6, 3.71428571428571, 0.00277777777777778, 
0.00555555555555556, 0.0166666666666667, 0.00555555555555556, 
0.0166666666666667, 0.0277777777777778, 0.00555555555555556, 
0.05, 0.00555555555555556, 0.025, 0.00555555555555556, 0.0333333333333333, 
0.0166666666666667, 0.00277777777777778, 0.0333333333333333, 
0.0277777777777778, 0.0222222222222222, 0.0472222222222222, 0.00555555555555556, 
0.0555555555555556, 0.0333333333333333, 0.0333333333333333, 0.0555555555555556, 
0.00555555555555556, 0.0277777777777778, 0.0222222222222222, 
0.0333333333333333, 0.0388888888888889, 0.0305555555555556, 0.0222222222222222, 
0.0444444444444444, 0.0166666666666667, 0.025, 0.0277777777777778, 
0.0166666666666667, 0.00555555555555556, 0.0138888888888889, 
0.0222222222222222, 0.0166666666666667, 0.0111111111111111, 0.0111111111111111, 
0.00555555555555556, 0.0333333333333333, 0.00555555555555556, 
0.0111111111111111, 0.00555555555555556, 0.00555555555555556, 
0.00555555555555556, 0.00277777777777778, 0.00277777777777778, 
0.00833333333333333, 0.025, 0.0305555555555556, 0.0472222222222222, 
0.075, 0.0805555555555556, 0.130555555555556, 0.136111111111111, 
0.161111111111111, 0.166666666666667, 0.2, 0.216666666666667, 
0.219444444444444, 0.252777777777778, 0.280555555555556, 0.302777777777778, 
0.35, 0.355555555555556, 0.411111111111111, 0.444444444444444, 
0.477777777777778, 0.533333333333333, 0.538888888888889, 0.566666666666667, 
0.588888888888889, 0.622222222222222, 0.661111111111111, 0.691666666666667, 
0.713888888888889, 0.758333333333333, 0.775, 0.8, 0.827777777777778, 
0.844444444444444, 0.85, 0.863888888888889, 0.886111111111111, 
0.902777777777778, 0.913888888888889, 0.925, 0.930555555555556, 
0.963888888888889, 0.969444444444444, 0.980555555555556, 0.986111111111111, 
0.991666666666667, 0.997222222222222, 1), .Dim = c(49L, 3L), .Dimnames = list(
    NULL, c("Order.Statistics", "Densities", "Cumulative.Probabilities"
    )))
.rank.von.neumann.dist.mat.7 <-
structure(c(0.214285714285714, 0.321428571428571, 0.428571428571429, 
0.5, 0.535714285714286, 0.607142857142857, 0.642857142857143, 
0.714285714285714, 0.75, 0.785714285714286, 0.821428571428571, 
0.857142857142857, 0.892857142857143, 0.928571428571428, 0.964285714285714, 
1, 1.03571428571429, 1.07142857142857, 1.10714285714286, 1.14285714285714, 
1.17857142857143, 1.21428571428571, 1.25, 1.28571428571429, 1.32142857142857, 
1.35714285714286, 1.39285714285714, 1.42857142857143, 1.46428571428571, 
1.5, 1.53571428571429, 1.57142857142857, 1.60714285714286, 1.64285714285714, 
1.67857142857143, 1.71428571428571, 1.75, 1.78571428571429, 1.82142857142857, 
1.85714285714286, 1.89285714285714, 1.92857142857143, 1.96428571428571, 
2, 2.03571428571429, 2.07142857142857, 2.10714285714286, 2.14285714285714, 
2.17857142857143, 2.21428571428571, 2.25, 2.28571428571429, 2.32142857142857, 
2.35714285714286, 2.39285714285714, 2.42857142857143, 2.46428571428571, 
2.5, 2.53571428571429, 2.57142857142857, 2.60714285714286, 2.64285714285714, 
2.67857142857143, 2.71428571428571, 2.75, 2.78571428571429, 2.82142857142857, 
2.85714285714286, 2.89285714285714, 2.92857142857143, 2.96428571428571, 
3, 3.03571428571429, 3.07142857142857, 3.10714285714286, 3.14285714285714, 
3.17857142857143, 3.21428571428571, 3.25, 3.28571428571429, 3.32142857142857, 
3.35714285714286, 3.39285714285714, 3.42857142857143, 3.46428571428571, 
3.5, 3.53571428571429, 3.57142857142857, 3.60714285714286, 3.67857142857143, 
3.75, 0.000396825396825397, 0.000793650793650794, 0.00277777777777778, 
0.000793650793650794, 0.00317460317460317, 0.00396825396825397, 
0.00317460317460317, 0.0111111111111111, 0.00158730158730159, 
0.00317460317460317, 0.00952380952380952, 0.00396825396825397, 
0.0119047619047619, 0.00158730158730159, 0.0103174603174603, 
0.00595238095238095, 0.00714285714285714, 0.0111111111111111, 
0.00634920634920635, 0.0166666666666667, 0.0150793650793651, 
0.000396825396825397, 0.019047619047619, 0.0154761904761905, 
0.00476190476190476, 0.0123015873015873, 0.019047619047619, 0.0142857142857143, 
0.0222222222222222, 0.00793650793650794, 0.0150793650793651, 
0.0234126984126984, 0.0142857142857143, 0.00714285714285714, 
0.0388888888888889, 0.0126984126984127, 0.0158730158730159, 0.0158730158730159, 
0.0206349206349206, 0.0297619047619048, 0.0166666666666667, 0.0107142857142857, 
0.0261904761904762, 0.0174603174603175, 0.0206349206349206, 0.0107142857142857, 
0.030952380952381, 0.0146825396825397, 0.0126984126984127, 0.0238095238095238, 
0.0166666666666667, 0.0206349206349206, 0.0277777777777778, 0.0123015873015873, 
0.0285714285714286, 0.0162698412698413, 0.0103174603174603, 0.0111111111111111, 
0.0246031746031746, 0.0111111111111111, 0.00952380952380952, 
0.0111111111111111, 0.0198412698412698, 0.0119047619047619, 0.00634920634920635, 
0.00793650793650794, 0.0182539682539683, 0.0126984126984127, 
0.00873015873015873, 0.00476190476190476, 0.0126984126984127, 
0.00515873015873016, 0.00714285714285714, 0.00674603174603175, 
0.00714285714285714, 0.00396825396825397, 0.00714285714285714, 
0.00357142857142857, 0.00634920634920635, 0.00476190476190476, 
0.000793650793650794, 0.00317460317460317, 0.00555555555555556, 
0.000793650793650794, 0.00158730158730159, 0.00158730158730159, 
0.00158730158730159, 0.00158730158730159, 0.000793650793650794, 
0.00238095238095238, 0.000793650793650794, 0.000396825396825397, 
0.00119047619047619, 0.00396825396825397, 0.00476190476190476, 
0.00793650793650794, 0.0119047619047619, 0.0150793650793651, 
0.0261904761904762, 0.0277777777777778, 0.030952380952381, 0.0404761904761905, 
0.0444444444444444, 0.0563492063492064, 0.0579365079365079, 0.0682539682539682, 
0.0742063492063492, 0.0813492063492064, 0.0924603174603175, 0.0988095238095238, 
0.115476190476191, 0.130555555555556, 0.130952380952381, 0.15, 
0.165476190476191, 0.170238095238095, 0.182539682539683, 0.201587301587302, 
0.215873015873016, 0.238095238095238, 0.246031746031746, 0.261111111111111, 
0.28452380952381, 0.298809523809524, 0.305952380952381, 0.34484126984127, 
0.357539682539683, 0.373412698412698, 0.389285714285714, 0.409920634920635, 
0.43968253968254, 0.456349206349206, 0.467063492063492, 0.493253968253968, 
0.510714285714286, 0.531349206349206, 0.542063492063492, 0.573015873015873, 
0.587698412698413, 0.600396825396825, 0.624206349206349, 0.640873015873016, 
0.661507936507936, 0.689285714285714, 0.701587301587302, 0.73015873015873, 
0.746428571428571, 0.756746031746032, 0.767857142857143, 0.792460317460317, 
0.803571428571429, 0.813095238095238, 0.824206349206349, 0.844047619047619, 
0.855952380952381, 0.862301587301587, 0.870238095238095, 0.888492063492063, 
0.901190476190476, 0.909920634920635, 0.91468253968254, 0.927380952380952, 
0.932539682539683, 0.93968253968254, 0.946428571428571, 0.953571428571429, 
0.957539682539683, 0.96468253968254, 0.968253968253968, 0.974603174603175, 
0.979365079365079, 0.98015873015873, 0.983333333333333, 0.988888888888889, 
0.98968253968254, 0.991269841269841, 0.992857142857143, 0.994444444444444, 
0.996031746031746, 0.996825396825397, 0.999206349206349, 1), .Dim = c(91L, 
3L), .Dimnames = list(NULL, c("Order.Statistics", "Densities", 
"Cumulative.Probabilities")))
.rank.von.neumann.dist.mat.8 <-
structure(c(0.166666666666667, 0.238095238095238, 0.30952380952381, 
0.357142857142857, 0.380952380952381, 0.428571428571429, 0.452380952380952, 
0.5, 0.523809523809524, 0.547619047619048, 0.571428571428571, 
0.595238095238095, 0.619047619047619, 0.642857142857143, 0.666666666666667, 
0.69047619047619, 0.714285714285714, 0.738095238095238, 0.761904761904762, 
0.785714285714286, 0.80952380952381, 0.833333333333333, 0.857142857142857, 
0.880952380952381, 0.904761904761905, 0.928571428571428, 0.952380952380952, 
0.976190476190476, 1, 1.02380952380952, 1.04761904761905, 1.07142857142857, 
1.09523809523809, 1.11904761904762, 1.14285714285714, 1.16666666666667, 
1.19047619047619, 1.21428571428571, 1.23809523809524, 1.26190476190476, 
1.28571428571429, 1.30952380952381, 1.33333333333333, 1.35714285714286, 
1.38095238095238, 1.40476190476191, 1.42857142857143, 1.45238095238095, 
1.47619047619048, 1.5, 1.52380952380952, 1.54761904761905, 1.57142857142857, 
1.59523809523809, 1.61904761904762, 1.64285714285714, 1.66666666666667, 
1.69047619047619, 1.71428571428571, 1.73809523809524, 1.76190476190476, 
1.78571428571429, 1.80952380952381, 1.83333333333333, 1.85714285714286, 
1.88095238095238, 1.90476190476191, 1.92857142857143, 1.95238095238095, 
1.97619047619048, 2, 2.02380952380952, 2.04761904761905, 2.07142857142857, 
2.09523809523809, 2.11904761904762, 2.14285714285714, 2.16666666666667, 
2.19047619047619, 2.21428571428571, 2.23809523809524, 2.26190476190476, 
2.28571428571429, 2.30952380952381, 2.33333333333333, 2.35714285714286, 
2.38095238095238, 2.4047619047619, 2.42857142857143, 2.45238095238095, 
2.47619047619048, 2.5, 2.52380952380952, 2.54761904761905, 2.57142857142857, 
2.59523809523809, 2.61904761904762, 2.64285714285714, 2.66666666666667, 
2.69047619047619, 2.71428571428571, 2.73809523809524, 2.76190476190476, 
2.78571428571429, 2.80952380952381, 2.83333333333333, 2.85714285714286, 
2.88095238095238, 2.9047619047619, 2.92857142857143, 2.95238095238095, 
2.97619047619048, 3, 3.02380952380952, 3.04761904761905, 3.07142857142857, 
3.09523809523809, 3.11904761904762, 3.14285714285714, 3.16666666666667, 
3.19047619047619, 3.21428571428571, 3.23809523809524, 3.26190476190476, 
3.28571428571429, 3.30952380952381, 3.33333333333333, 3.35714285714286, 
3.38095238095238, 3.4047619047619, 3.42857142857143, 3.45238095238095, 
3.47619047619048, 3.5, 3.52380952380952, 3.54761904761905, 3.57142857142857, 
3.59523809523809, 3.61904761904762, 3.64285714285714, 3.66666666666667, 
3.69047619047619, 3.71428571428571, 3.73809523809524, 3.76190476190476, 
3.78571428571429, 3.83333333333333, 4.96031746031746e-05, 9.92063492063492e-05, 
0.000396825396825397, 9.92063492063492e-05, 0.000496031746031746, 
0.000496031746031746, 0.00064484126984127, 0.00163690476190476, 
0.000496031746031746, 0.000446428571428571, 0.00248015873015873, 
0.000595238095238095, 0.00158730158730159, 0.00158730158730159, 
0.00148809523809524, 0.00362103174603175, 0.000892857142857143, 
0.0035218253968254, 0.00148809523809524, 0.00426587301587302, 
0.00317460317460317, 0.00109126984126984, 0.00476190476190476, 
0.00530753968253968, 0.00119047619047619, 0.00615079365079365, 
0.00486111111111111, 0.00496031746031746, 0.00446428571428571, 
0.00461309523809524, 0.00535714285714286, 0.00892857142857143, 
0.00386904761904762, 0.00560515873015873, 0.00704365079365079, 
0.00714285714285714, 0.00476190476190476, 0.0109126984126984, 
0.0060515873015873, 0.0110119047619048, 0.00466269841269841, 
0.00962301587301587, 0.0128968253968254, 0.0097718253968254, 
0.0064484126984127, 0.00902777777777778, 0.0113095238095238, 
0.0134424603174603, 0.00555555555555556, 0.014781746031746, 0.00962301587301587, 
0.010515873015873, 0.0119047619047619, 0.0103670634920635, 0.0110119047619048, 
0.0180555555555556, 0.00505952380952381, 0.0182043650793651, 
0.0165674603174603, 0.0124503968253968, 0.0100198412698413, 0.013640873015873, 
0.0141865079365079, 0.0171626984126984, 0.0108134920634921, 0.0159722222222222, 
0.0113095238095238, 0.0184027777777778, 0.010515873015873, 0.0134920634920635, 
0.0123015873015873, 0.0140873015873016, 0.00843253968253968, 
0.0167162698412698, 0.0163690476190476, 0.0166666666666667, 0.0111111111111111, 
0.014781746031746, 0.0153769841269841, 0.0154265873015873, 0.00882936507936508, 
0.0178075396825397, 0.0113095238095238, 0.0112599206349206, 0.00902777777777778, 
0.0140873015873016, 0.0118055555555556, 0.0141369047619048, 0.00704365079365079, 
0.0141865079365079, 0.0138888888888889, 0.0110119047619048, 0.00793650793650794, 
0.0124503968253968, 0.0116071428571429, 0.0100198412698413, 0.00714285714285714, 
0.0121527777777778, 0.00714285714285714, 0.00843253968253968, 
0.00744047619047619, 0.00873015873015873, 0.00734126984126984, 
0.00952380952380952, 0.00257936507936508, 0.00773809523809524, 
0.00803571428571428, 0.00639880952380952, 0.00496031746031746, 
0.0066468253968254, 0.00525793650793651, 0.00649801587301587, 
0.00327380952380952, 0.00555555555555556, 0.00496031746031746, 
0.00386904761904762, 0.00248015873015873, 0.00520833333333333, 
0.00297619047619048, 0.00277777777777778, 0.00218253968253968, 
0.00367063492063492, 0.00396825396825397, 0.0027281746031746, 
0.000892857142857143, 0.00203373015873016, 0.00178571428571429, 
0.00218253968253968, 0.000793650793650794, 0.00208333333333333, 
0.000595238095238095, 0.00114087301587302, 0.000992063492063492, 
0.000545634920634921, 0.000892857142857143, 0.00124007936507937, 
9.92063492063492e-05, 0.000992063492063492, 0.000297619047619048, 
0.000496031746031746, 9.92063492063492e-05, 0.000297619047619048, 
0.000297619047619048, 9.92063492063492e-05, 9.92063492063492e-05, 
0.000198412698412698, 4.96031746031746e-05, 4.96031746031746e-05, 
0.000148809523809524, 0.000545634920634921, 0.00064484126984127, 
0.00114087301587302, 0.00163690476190476, 0.00228174603174603, 
0.00391865079365079, 0.00441468253968254, 0.00486111111111111, 
0.00734126984126984, 0.00793650793650794, 0.00952380952380952, 
0.0111111111111111, 0.0125992063492064, 0.0162202380952381, 0.0171130952380952, 
0.0206349206349206, 0.0221230158730159, 0.0263888888888889, 0.0295634920634921, 
0.0306547619047619, 0.0354166666666667, 0.0407242063492064, 0.0419146825396825, 
0.0480654761904762, 0.0529265873015873, 0.0578869047619048, 0.0623511904761905, 
0.0669642857142857, 0.0723214285714286, 0.08125, 0.0851190476190476, 
0.0907242063492063, 0.0977678571428571, 0.104910714285714, 0.109672619047619, 
0.120585317460317, 0.126636904761905, 0.13764880952381, 0.142311507936508, 
0.151934523809524, 0.164831349206349, 0.174603174603175, 0.181051587301587, 
0.190079365079365, 0.201388888888889, 0.214831349206349, 0.220386904761905, 
0.235168650793651, 0.244791666666667, 0.25530753968254, 0.267212301587302, 
0.277579365079365, 0.28859126984127, 0.306646825396825, 0.311706349206349, 
0.329910714285714, 0.346478174603175, 0.358928571428571, 0.368948412698413, 
0.382589285714286, 0.396775793650794, 0.413938492063492, 0.424751984126984, 
0.440724206349206, 0.45203373015873, 0.470436507936508, 0.480952380952381, 
0.494444444444445, 0.506746031746032, 0.520833333333333, 0.529265873015873, 
0.545982142857143, 0.56235119047619, 0.579017857142857, 0.590128968253968, 
0.604910714285714, 0.620287698412698, 0.635714285714286, 0.644543650793651, 
0.662351190476191, 0.673660714285714, 0.684920634920635, 0.693948412698413, 
0.708035714285714, 0.71984126984127, 0.733978174603175, 0.741021825396825, 
0.755208333333333, 0.769097222222222, 0.780109126984127, 0.788045634920635, 
0.800496031746032, 0.812103174603175, 0.822123015873016, 0.829265873015873, 
0.841418650793651, 0.848561507936508, 0.856994047619048, 0.864434523809524, 
0.873164682539682, 0.880505952380952, 0.890029761904762, 0.892609126984127, 
0.900347222222222, 0.908382936507937, 0.914781746031746, 0.919742063492063, 
0.926388888888889, 0.931646825396825, 0.938144841269841, 0.941418650793651, 
0.946974206349206, 0.951934523809524, 0.955803571428571, 0.95828373015873, 
0.963492063492064, 0.966468253968254, 0.969246031746032, 0.971428571428571, 
0.975099206349206, 0.97906746031746, 0.981795634920635, 0.982688492063492, 
0.984722222222222, 0.986507936507937, 0.988690476190476, 0.989484126984127, 
0.99156746031746, 0.992162698412698, 0.993303571428571, 0.994295634920635, 
0.99484126984127, 0.995734126984127, 0.996974206349206, 0.997073412698413, 
0.998065476190476, 0.998363095238095, 0.998859126984127, 0.998958333333333, 
0.999255952380952, 0.999553571428571, 0.999652777777778, 0.999751984126984, 
0.999950396825397, 1), .Dim = c(147L, 3L), .Dimnames = list(NULL, 
    c("Order.Statistics", "Densities", "Cumulative.Probabilities"
    )))
.rank.von.neumann.dist.mat.9 <-
structure(c(0.133333333333333, 0.183333333333333, 0.233333333333333, 
0.266666666666667, 0.283333333333333, 0.316666666666667, 0.333333333333333, 
0.366666666666667, 0.383333333333333, 0.4, 0.416666666666667, 
0.433333333333333, 0.45, 0.466666666666667, 0.483333333333333, 
0.5, 0.516666666666667, 0.533333333333333, 0.55, 0.566666666666667, 
0.583333333333333, 0.6, 0.616666666666667, 0.633333333333333, 
0.65, 0.666666666666667, 0.683333333333333, 0.7, 0.716666666666667, 
0.733333333333333, 0.75, 0.766666666666667, 0.783333333333333, 
0.8, 0.816666666666667, 0.833333333333333, 0.85, 0.866666666666667, 
0.883333333333333, 0.9, 0.916666666666667, 0.933333333333333, 
0.95, 0.966666666666667, 0.983333333333333, 1, 1.01666666666667, 
1.03333333333333, 1.05, 1.06666666666667, 1.08333333333333, 1.1, 
1.11666666666667, 1.13333333333333, 1.15, 1.16666666666667, 1.18333333333333, 
1.2, 1.21666666666667, 1.23333333333333, 1.25, 1.26666666666667, 
1.28333333333333, 1.3, 1.31666666666667, 1.33333333333333, 1.35, 
1.36666666666667, 1.38333333333333, 1.4, 1.41666666666667, 1.43333333333333, 
1.45, 1.46666666666667, 1.48333333333333, 1.5, 1.51666666666667, 
1.53333333333333, 1.55, 1.56666666666667, 1.58333333333333, 1.6, 
1.61666666666667, 1.63333333333333, 1.65, 1.66666666666667, 1.68333333333333, 
1.7, 1.71666666666667, 1.73333333333333, 1.75, 1.76666666666667, 
1.78333333333333, 1.8, 1.81666666666667, 1.83333333333333, 1.85, 
1.86666666666667, 1.88333333333333, 1.9, 1.91666666666667, 1.93333333333333, 
1.95, 1.96666666666667, 1.98333333333333, 2, 2.01666666666667, 
2.03333333333333, 2.05, 2.06666666666667, 2.08333333333333, 2.1, 
2.11666666666667, 2.13333333333333, 2.15, 2.16666666666667, 2.18333333333333, 
2.2, 2.21666666666667, 2.23333333333333, 2.25, 2.26666666666667, 
2.28333333333333, 2.3, 2.31666666666667, 2.33333333333333, 2.35, 
2.36666666666667, 2.38333333333333, 2.4, 2.41666666666667, 2.43333333333333, 
2.45, 2.46666666666667, 2.48333333333333, 2.5, 2.51666666666667, 
2.53333333333333, 2.55, 2.56666666666667, 2.58333333333333, 2.6, 
2.61666666666667, 2.63333333333333, 2.65, 2.66666666666667, 2.68333333333333, 
2.7, 2.71666666666667, 2.73333333333333, 2.75, 2.76666666666667, 
2.78333333333333, 2.8, 2.81666666666667, 2.83333333333333, 2.85, 
2.86666666666667, 2.88333333333333, 2.9, 2.91666666666667, 2.93333333333333, 
2.95, 2.96666666666667, 2.98333333333333, 3, 3.01666666666667, 
3.03333333333333, 3.05, 3.06666666666667, 3.08333333333333, 3.1, 
3.11666666666667, 3.13333333333333, 3.15, 3.16666666666667, 3.18333333333333, 
3.2, 3.21666666666667, 3.23333333333333, 3.25, 3.26666666666667, 
3.28333333333333, 3.3, 3.31666666666667, 3.33333333333333, 3.35, 
3.36666666666667, 3.38333333333333, 3.4, 3.41666666666667, 3.43333333333333, 
3.45, 3.46666666666667, 3.48333333333333, 3.5, 3.51666666666667, 
3.53333333333333, 3.55, 3.56666666666667, 3.58333333333333, 3.6, 
3.61666666666667, 3.63333333333333, 3.65, 3.66666666666667, 3.68333333333333, 
3.7, 3.71666666666667, 3.73333333333333, 3.75, 3.76666666666667, 
3.78333333333333, 3.81666666666667, 3.85, 5.51146384479718e-06, 
1.10229276895944e-05, 4.96031746031746e-05, 1.10229276895944e-05, 
6.61375661375661e-05, 5.51146384479718e-05, 0.000104717813051146, 
0.000209435626102293, 8.81834215167549e-05, 5.51146384479718e-05, 
0.000363756613756614, 0.000104717813051146, 0.000187389770723104, 
0.000451940035273369, 0.000187389770723104, 0.000589726631393298, 
0.000264550264550265, 0.000496031746031746, 0.000716490299823633, 
0.00050705467372134, 0.000947971781305115, 0.000314153439153439, 
0.00115740740740741, 0.000920414462081129, 0.000418871252204586, 
0.00135582010582011, 0.00130070546737213, 0.000964506172839506, 
0.00164241622574956, 0.00114638447971781, 0.00173059964726631, 
0.00178020282186949, 0.00130070546737213, 0.0015542328042328, 
0.00259038800705467, 0.00181327160493827, 0.00182980599647266, 
0.00224867724867725, 0.00262345679012346, 0.00205026455026455, 
0.00265652557319224, 0.00227072310405644, 0.00403439153439153, 
0.00229276895943563, 0.00315255731922399, 0.0029265873015873, 
0.00423280423280423, 0.00380842151675485, 0.00251322751322751, 
0.00425485008818342, 0.00498236331569665, 0.00275573192239859, 
0.00496031746031746, 0.00357694003527337, 0.00486111111111111, 
0.00509810405643739, 0.00347222222222222, 0.00489417989417989, 
0.00724206349206349, 0.00359898589065256, 0.00633818342151675, 
0.00562169312169312, 0.00682319223985891, 0.00513117283950617, 
0.00568783068783069, 0.00634920634920635, 0.00773809523809524, 
0.00587522045855379, 0.00716490299823633, 0.00604056437389771, 
0.00992063492063492, 0.0058641975308642, 0.0058641975308642, 
0.008206569664903, 0.0087962962962963, 0.00626102292768959, 0.0083994708994709, 
0.00731371252204586, 0.0106812169312169, 0.00725308641975309, 
0.0078042328042328, 0.00811287477954145, 0.0122354497354497, 
0.0070326278659612, 0.00867504409171076, 0.00909942680776014, 
0.0111111111111111, 0.00822861552028219, 0.00965608465608466, 
0.00940806878306878, 0.0117283950617284, 0.00786485890652557, 
0.0095789241622575, 0.0091765873015873, 0.0126873897707231, 0.00767746913580247, 
0.00974426807760141, 0.0104387125220459, 0.0119157848324515, 
0.0072365520282187, 0.0114858906525573, 0.009755291005291, 0.012092151675485, 
0.00940806878306878, 0.0101190476190476, 0.0110725308641975, 
0.0125661375661376, 0.00731922398589065, 0.0104056437389771, 
0.0105654761904762, 0.0120039682539683, 0.00746252204585538, 
0.010626102292769, 0.00933641975308642, 0.0120590828924162, 0.00877425044091711, 
0.0104497354497355, 0.00876873897707231, 0.0121693121693122, 
0.00713183421516755, 0.00934744268077601, 0.0109347442680776, 
0.011033950617284, 0.0074129188712522, 0.0106481481481482, 0.00895612874779541, 
0.0101521164021164, 0.00739638447971781, 0.00819003527336861, 
0.00832231040564374, 0.0102954144620811, 0.00586970899470899, 
0.00931437389770723, 0.00855930335097002, 0.00875220458553792, 
0.00604056437389771, 0.00849867724867725, 0.00807429453262787, 
0.00864197530864197, 0.00497685185185185, 0.00805776014109347, 
0.00713734567901235, 0.00817901234567901, 0.00499889770723104, 
0.00651455026455027, 0.00638227513227513, 0.00626102292768959, 
0.00471781305114638, 0.00645943562610229, 0.00514770723104056, 
0.00690035273368607, 0.00341710758377425, 0.00534611992945326, 
0.00515321869488536, 0.00544532627865961, 0.00376984126984127, 
0.00462962962962963, 0.00450286596119929, 0.0050705467372134, 
0.00319664902998236, 0.00456349206349206, 0.00354938271604938, 
0.00407848324514991, 0.0029320987654321, 0.00330687830687831, 
0.00288800705467372, 0.00358245149911817, 0.00179122574955908, 
0.00336199294532628, 0.00341159611992945, 0.00299823633156967, 
0.00154320987654321, 0.00246913580246914, 0.00219356261022928, 
0.00232583774250441, 0.00164792768959436, 0.00224867724867725, 
0.0015542328042328, 0.00200617283950617, 0.00108024691358025, 
0.0015652557319224, 0.00126763668430335, 0.00153218694885362, 
0.000733024691358025, 0.00111331569664903, 0.00100859788359788, 
0.00130070546737213, 0.000617283950617284, 0.000881834215167548, 
0.000843253968253968, 0.000881834215167548, 0.000562169312169312, 
0.000760582010582011, 0.000418871252204586, 0.000661375661375661, 
0.000325176366843034, 0.000396825396825397, 0.000341710758377425, 
0.000374779541446208, 0.000165343915343915, 0.000363756613756614, 
0.000286596119929453, 0.000209435626102293, 9.92063492063492e-05, 
0.000264550264550265, 9.92063492063492e-05, 0.00017636684303351, 
3.30687830687831e-05, 9.92063492063492e-05, 6.61375661375661e-05, 
5.51146384479718e-05, 2.20458553791887e-05, 5.51146384479718e-05, 
5.51146384479718e-05, 1.10229276895944e-05, 5.51146384479718e-06, 
1.65343915343915e-05, 6.61375661375661e-05, 7.71604938271605e-05, 
0.000143298059964727, 0.000198412698412698, 0.000303130511463845, 
0.000512566137566138, 0.000600749559082892, 0.000655864197530864, 
0.00101962081128748, 0.00112433862433862, 0.00131172839506173, 
0.0017636684303351, 0.0019510582010582, 0.0025407848324515, 0.00280533509700176, 
0.00330136684303351, 0.00401785714285714, 0.00452491181657848, 
0.0054728835978836, 0.00578703703703704, 0.00694444444444444, 
0.00786485890652557, 0.00828373015873016, 0.00963955026455026, 
0.0109402557319224, 0.0119047619047619, 0.0135471781305115, 0.0146935626102293, 
0.0164241622574956, 0.0182043650793651, 0.0195050705467372, 0.02105930335097, 
0.0236496913580247, 0.025462962962963, 0.0272927689594356, 0.0295414462081129, 
0.0321649029982363, 0.0342151675485009, 0.0368716931216931, 0.0391424162257496, 
0.0431768077601411, 0.0454695767195767, 0.0486221340388007, 0.051548721340388, 
0.0557815255731922, 0.0595899470899471, 0.0621031746031746, 0.066358024691358, 
0.0713403880070547, 0.0740961199294533, 0.0790564373897707, 0.0826333774250441, 
0.0874944885361552, 0.0925925925925926, 0.0960648148148148, 0.100958994708995, 
0.108201058201058, 0.111800044091711, 0.118138227513228, 0.123759920634921, 
0.13058311287478, 0.135714285714286, 0.141402116402116, 0.147751322751323, 
0.155489417989418, 0.161364638447972, 0.168529541446208, 0.174570105820106, 
0.184490740740741, 0.190354938271605, 0.196219135802469, 0.204425705467372, 
0.213222001763668, 0.219483024691358, 0.227882495590829, 0.235196208112875, 
0.245877425044092, 0.253130511463845, 0.260934744268078, 0.269047619047619, 
0.281283068783069, 0.28831569664903, 0.296990740740741, 0.306090167548501, 
0.317201278659612, 0.325429894179894, 0.335085978835979, 0.344494047619048, 
0.356222442680776, 0.364087301587302, 0.373666225749559, 0.382842813051146, 
0.39553020282187, 0.403207671957672, 0.412951940035273, 0.423390652557319, 
0.435306437389771, 0.442542989417989, 0.454028880070547, 0.463784171075838, 
0.475876322751323, 0.485284391534392, 0.495403439153439, 0.506475970017637, 
0.519042107583774, 0.526361331569665, 0.536766975308642, 0.547332451499118, 
0.559336419753086, 0.566798941798942, 0.577425044091711, 0.586761463844797, 
0.598820546737213, 0.60759479717813, 0.618044532627866, 0.626813271604938, 
0.63898258377425, 0.646114417989418, 0.655461860670194, 0.666396604938272, 
0.677430555555556, 0.684843474426808, 0.695491622574956, 0.704447751322751, 
0.714599867724868, 0.721996252204586, 0.730186287477954, 0.738508597883598, 
0.748804012345679, 0.754673721340388, 0.763988095238095, 0.772547398589065, 
0.781299603174603, 0.787340167548501, 0.795838844797178, 0.803913139329806, 
0.812555114638448, 0.8175319664903, 0.825589726631393, 0.832727072310406, 
0.840906084656085, 0.845904982363316, 0.852419532627866, 0.858801807760141, 
0.865062830687831, 0.869780643738977, 0.876240079365079, 0.88138778659612, 
0.888288139329806, 0.89170524691358, 0.897051366843034, 0.902204585537919, 
0.907649911816579, 0.91141975308642, 0.916049382716049, 0.920552248677249, 
0.925622795414462, 0.928819444444444, 0.933382936507936, 0.936932319223986, 
0.941010802469136, 0.943942901234568, 0.947249779541446, 0.95013778659612, 
0.953720238095238, 0.955511463844797, 0.958873456790123, 0.962285052910053, 
0.965283289241623, 0.966826499118166, 0.969295634920635, 0.971489197530864, 
0.973815035273369, 0.975462962962963, 0.97771164021164, 0.979265873015873, 
0.981272045855379, 0.982352292768959, 0.983917548500882, 0.985185185185185, 
0.986717372134039, 0.987450396825397, 0.988563712522046, 0.989572310405644, 
0.990873015873016, 0.991490299823633, 0.992372134038801, 0.993215388007055, 
0.994097222222222, 0.994659391534392, 0.995419973544974, 0.995838844797178, 
0.996500220458554, 0.996825396825397, 0.997222222222222, 0.9975639329806, 
0.997938712522046, 0.99810405643739, 0.998467813051146, 0.998754409171076, 
0.998963844797178, 0.999063051146384, 0.999327601410935, 0.999426807760141, 
0.999603174603175, 0.999636243386243, 0.99973544973545, 0.999801587301587, 
0.999856701940035, 0.999878747795414, 0.999933862433862, 0.99998897707231, 
1), .Dim = c(215L, 3L), .Dimnames = list(NULL, c("Order.Statistics", 
"Densities", "Cumulative.Probabilities")))
.royston.93.array <-
structure(c(0.164, 0.1736, 0.256, 0.1843, 0.1894, 0.248, 0.533, 
0.315, -0.00635, 1.56, 0.27, 0, 0.556, 0.622, NA, 0.371, 0.624, 
NA), .Dim = c(3L, 2L, 3L), .Dimnames = list(c("0.90", "0.95", 
"0.99"), c("W", "W'"), c("A", "B", "C")))
.title.and.axes.pars <-
c("main", "sub", "xlab", "ylab", "line", "outer", "axes")
