% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.icm}
\alias{plot.icm}
\title{Plot Data from a Stochastic Individual Contact Epidemic Model}
\usage{
\method{plot}{icm}(x, y, popfrac, sim.lines, sims, sim.col, sim.lwd, sim.alpha,
  mean.line = TRUE, mean.smooth = FALSE, mean.col, mean.lwd, mean.lty, qnts,
  qnts.col, qnts.alpha, leg, leg.cex = 0.8, axs = "r", add = FALSE, ...)
}
\arguments{
\item{x}{An \code{EpiModel} object of class \code{icm}.}

\item{y}{Output compartments or flows from \code{icm} object to plot.}

\item{popfrac}{If \code{TRUE}, plot prevalence of values rather than numbers
(see details).}

\item{sim.lines}{If \code{TRUE}, plot individual simulation lines. Default is
to plot lines for one-group models but not for two-group models.}

\item{sims}{Vector representing which individual simulation lines to plot,
with default to plot all simulations.}

\item{sim.col}{Vector of any standard R color format for simulation lines.}

\item{sim.lwd}{Line width for simulation lines.}

\item{sim.alpha}{Transparency level for simulation lines, where 0 = transparent
and 1 = opaque (see \code{\link{transco}}).}

\item{mean.line}{If \code{TRUE}, plot mean of simulations across time.}

\item{mean.smooth}{If \code{TRUE}, use a lowess smoother on the mean line.}

\item{mean.col}{Vector of any standard R color format for mean lines.}

\item{mean.lwd}{Line width for mean lines.}

\item{mean.lty}{Line type for mean lines.}

\item{qnts}{If numeric, plot polygon of simulation quantiles based on the
range implied by the argument (see details). If \code{FALSE}, suppress
polygon from plot.}

\item{qnts.col}{Vector of any standard R color format for polygons.}

\item{qnts.alpha}{Transparency level for quantile polygons, where 0 =
transparent and 1 = opaque (see \code{\link{transco}}).}

\item{leg}{If \code{TRUE}, plot default legend.}

\item{leg.cex}{Legend scale size.}

\item{axs}{Plot axis type (see \code{\link{par}} for details), with default
to \code{"r"}.}

\item{add}{If \code{TRUE}, new plot window is not called and lines are added to
existing plot window.}

\item{...}{Additional arguments to pass to main plot (see
       \code{\link{plot.default}}).}
}
\description{
Plots epidemiological data from a stochastic individual contact
             model simulated with \code{icm}.
}
\details{
This plotting function will extract the epidemiological output from a model
object of class \code{icm} and plot the time series data of disease prevalence
and other results. The summary statistics that the function calculates and
plots are individual simulation lines, means of the individual simulation
lines, and quantiles of those individual simulation lines. The mean line,
toggled on with \code{mean.line=TRUE} is calculated as the row mean
across simulations at each time step.

Compartment prevalences are the size of a compartment over some denominator.
To plot the raw numbers from any compartment, use \code{popfrac=FALSE}; this
is the default for any plots of flows. The \code{popfrac} parameter calculates
and plots the denominators of all specified compartments using these rules: 1)
for one-group models, the prevalence of any compartment is the compartment size
divided by the total population size; 2) for two-group models, the prevalence
of any compartment is the compartment size divided by the group population size.

The quantiles show the range of outcome values within a certain specified
quantile range. By default, the interquartile range is shown: that is the
middle 50\% of the data. This is specified by \code{qnts=0.5}. To show the
middle 95\% of the data, specify \code{qnts=0.95}. To toggle off the polygons
where they are plotted by default, specify \code{qnts=FALSE}.
}
\examples{
\dontrun{
## Example 1: Plotting multiple compartment values from SIR model
param <- param.icm(inf.prob = 0.5, act.rate = 0.5, rec.rate = 0.02)
init <- init.icm(s.num = 500, i.num = 1, r.num = 0)
control <- control.icm(type = "SIR", nsteps = 100,
                       nsims = 3, verbose = FALSE)
mod <- icm(param, init, control)
plot(mod)

## Example 2: Plot only infected with specific output from SI model
param <- param.icm(inf.prob = 0.25, act.rate = 0.25)
init <- init.icm(s.num = 500, i.num = 10)
control <- control.icm(type = "SI", nsteps = 100,
                       nsims = 3, verbose = FALSE)
mod2 <- icm(param, init, control)

# Plot prevalence
plot(mod2, y = "i.num", mean.line = FALSE)

# Plot incidence
plot(mod2, y = "si.flow", mean.smooth = TRUE)
}
}
\seealso{
\code{\link{icm}}
}
\keyword{plot}

