% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_estimates}
\alias{plot_estimates}
\title{Plot Estimates}
\usage{
plot_estimates(
  estimate,
  reported,
  ylab = "Cases",
  hline,
  obs_as_col = TRUE,
  max_plot = 10
)
}
\arguments{
\item{estimate}{A data.table of estimates containing the following variables: date, type
(must contain "estimate", "estimate based on partial data" and optionally "forecast"),}

\item{reported}{A data.table of reported cases with the following variables: date, confirm.}

\item{ylab}{Character string, defaulting to "Cases". Title for the plot y axis.}

\item{hline}{Numeric, if supplied gives the horizontal intercept for a indicator line.}

\item{obs_as_col}{Logical, defaults to \code{TRUE}. Should observed data, if supplied, be plotted using columns or
as points (linked using a line).}

\item{max_plot}{Numeric, defaults to 10. A multiplicative upper bound on the number of cases shown on the plot. Based
on the maximum number of reported cases.}
}
\value{
A \code{ggplot2} object
}
\description{
Plot Estimates
}
\examples{
\donttest{
## Define example cases
cases <- EpiNow2::example_confirmed[1:40]

 
## Set up example generation time
generation_time <- list(mean = EpiNow2::covid_generation_times[1, ]$mean,
                        mean_sd = EpiNow2::covid_generation_times[1, ]$mean_sd,
                        sd = EpiNow2::covid_generation_times[1, ]$sd,
                        sd_sd = EpiNow2::covid_generation_times[1, ]$sd_sd,
                        max = 30)
## Set                   
incubation_period <- list(mean = EpiNow2::covid_incubation_period[1, ]$mean,
                          mean_sd = EpiNow2::covid_incubation_period[1, ]$mean_sd,
                          sd = EpiNow2::covid_incubation_period[1, ]$sd,
                          sd_sd = EpiNow2::covid_incubation_period[1, ]$sd_sd,
                          max = 30)
                   
reporting_delay <- list(mean = log(5),
                        mean_sd = log(2),
                        sd = log(2),
                        sd_sd = log(1.5),
                        max = 30)
                        
## Run model
out <- EpiNow2::estimate_infections(cases, family = "negbin",
                                    generation_time = generation_time,
                                    delays = list(incubation_period, reporting_delay),
                                    samples = 1000, warmup = 200, 
                                    cores = ifelse(interactive(), 4, 1),
                                    chains = 4, horizon = 7, estimate_rt = TRUE, verbose = TRUE)
## Plot infections
plot_estimates(
  estimate = out$summarised[variable == "infections"],
  reported = cases,
  ylab = "Cases", max_plot = 2) + ggplot2::facet_wrap(~type, scales = "free_y")

## Plot reported cases estimated via Rt
plot_estimates(estimate = out$summarised[variable == "reported_cases"],
               reported = cases,
               ylab = "Cases")
               
## Plot Rt estimates
plot_estimates(estimate = out$summarised[variable == "R"],
               ylab = "Effective Reproduction No.",
               hline = 1)

}
}
