% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{report_cases}
\alias{report_cases}
\title{Report case counts by date of report}
\usage{
report_cases(
  case_estimates,
  case_forecast = NULL,
  delays,
  type = "sample",
  reporting_effect
)
}
\arguments{
\item{case_estimates}{A data.table of case estimates with the following variables: date, sample, cases}

\item{case_forecast}{A data.table of case forecasts with the following variables: date, sample, cases. If not supplied the
default is not to incorporate forecasts.}

\item{delays}{A list of delays (i.e incubation period/reporting delay) between infection and report.
Each list entry must also be a list containing the mean, standard deviation of the mean (mean_sd),
standard deviation (sd), standard deviation of the standard deviation and the maximum allowed value for the
that delay (assuming a lognormal distribution with all parameters excepting the max allowed value
on the log scale).}

\item{type}{Character string indicating the method to use to transform counts. Supports either "sample"
which approximates sampling or "median" would shift by the median of the distribution.}

\item{reporting_effect}{A \code{data.table} giving the weekly reporting effect with the following variables:
\code{sample} (must be the same as in \code{nowcast}), \code{effect} (numeric scaling factor for each weekday), \code{day}
(numeric 1 - 7 (1 = Monday and 7 = Sunday)). If not supplied then no weekly reporting effect is assumed.}
}
\value{
A list of \code{data.table}s. The first entry contains the following variables \code{sample}, \code{date} and \code{cases} with the second
being summarised across samples.
}
\description{
Report case counts by date of report
}
\examples{
\donttest{
## Define example cases
cases <- EpiNow2::example_confirmed[1:40]

 
## Set up example generation time
generation_time <- list(mean = EpiNow2::covid_generation_times[1, ]$mean,
                        mean_sd = EpiNow2::covid_generation_times[1, ]$mean_sd,
                        sd = EpiNow2::covid_generation_times[1, ]$sd,
                        sd_sd = EpiNow2::covid_generation_times[1, ]$sd_sd,
                        max = 30)
## Set                   
incubation_period <- list(mean = EpiNow2::covid_incubation_period[1, ]$mean,
                          mean_sd = EpiNow2::covid_incubation_period[1, ]$mean_sd,
                          sd = EpiNow2::covid_incubation_period[1, ]$sd,
                          sd_sd = EpiNow2::covid_incubation_period[1, ]$sd_sd,
                          max = 30)
                   
reporting_delay <- list(mean = log(5),
                        mean_sd = log(2),
                        sd = log(2),
                        sd_sd = log(1.5),
                        max = 30)
                        
## Run model
out <- EpiNow2::estimate_infections(cases, family = "negbin",
                                    generation_time = generation_time,
                                    delays = list(incubation_period, reporting_delay),
                                    samples = 1000, warmup = 200, 
                                    cores = ifelse(interactive(), 4, 1), chains = 4,
                                    estimate_rt =  FALSE, verbose = TRUE)
                            
                     
reported_cases <- report_cases(case_estimates = out$samples[variable == "infections"][, 
                                                            cases := value][, value := NULL],
                               delays = list(incubation_period, reporting_delay),
                               type = "sample")
                               
print(reported_cases)
}
}
