% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{apply_default_cdf_cutoff}
\alias{apply_default_cdf_cutoff}
\title{Apply default CDF cutoff to a <dist_spec> if it is unconstrained}
\usage{
apply_default_cdf_cutoff(dist, default_cdf_cutoff, cdf_cutoff_set)
}
\arguments{
\item{dist}{A <dist_spec>}

\item{default_cdf_cutoff}{Numeric; default CDF cutoff to be used if an
unconstrained distribution is passed as \code{dist}. If \code{dist} is already
constrained by having a maximum or CDF cutoff this is ignored.}

\item{cdf_cutoff_set}{Logical; whether the default CDF cutoff has been set by
the user; if yes and \code{dist} is constrained a warning is issued}
}
\value{
A <dist_spec> with the default CDF cutoff set if previously not
constrained
}
\description{
Apply default CDF cutoff to a <dist_spec> if it is unconstrained
}
\keyword{internal}
