% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EN_Ticker_Performance.R
\name{EN_Ticker_Performance}
\alias{EN_Ticker_Performance}
\title{Get Ticker Historical Performance}
\usage{
EN_Ticker_Performance(ticker, escape = FALSE, stock_type = "Eq_Ind")
}
\arguments{
\item{ticker}{A character string representing the company's ticker symbol.}

\item{escape}{Boolean, either TRUE or FALSE. If escape is True, it means you're providing the DNA (ISIN-Market identifier) directly. Giving T to escape is helpful to avoid time-consuming operations; otherwise, F means you need to provide the Ticker symbol, name, or ISIN and the type of market to which it belongs.}

\item{stock_type}{The type of the ticker: 'Eq_Ind' for Stocks and Indexes, 'Fund' or "F" for Fund tickers, 'Bond' or "B" for Bond tickers, and 'Etfs' or "E" for EFTs.}
}
\value{
A data frame containing historical performance data of the specified company.
If the ticker is not found, it returns the message "Ticker not found."
}
\description{
This function retrieves the historical performance data of a company listed on the Euronext exchange
based on its ticker symbol. It returns a table with details such as the highest and lowest stock prices,
date of the highest and lowest prices, and other relevant information.
}
\examples{

library(httr)
library(httr2)
library(rvest)
library(jsonlite)
library(stringr)
library(magrittr)

# Get Performance of Bond issued by A2A S.p.A.
dt1 = EN_Ticker_Performance("XS1195347478-ETLX", escape = TRUE)
#print(dt1[, c(1:6,8,12)])

\donttest{
# Get Performance of Ticker ABCA
dt = EN_Ticker_Performance("ABCA")
print(dt)
# Get Performance of ETF AAPL
EN_Ticker_Performance("AAPL", stock_type = "E")

# Get Performance of ACOMEA EMERGING Q2 Fund
dt2 = EN_Ticker_Performance("IT0005091126", stock_type ='F')
print(dt2[, c(1:6,8,12)])

# Get Performance of AEX All-Share Index
dt3 = EN_Ticker_Performance("AEX All-Share Index GR")
print(dt3[, c(1:6,8,12)])

}

}
\seealso{
\code{\link{EN_GetISIN}} to retrieve the ISIN for a given ticker.

Other Data Retrieval: 
\code{\link{EN_Get_OB}()},
\code{\link{EN_HistData_bis}()},
\code{\link{EN_HistData}()},
\code{\link{EN_Overview_plot}()},
\code{\link{EN_Stock.Performers}()},
\code{\link{EN_Ticker_hcData}()},
\code{\link{EN_Ticker_infos}()},
\code{\link{EN_intraday_Data}()},
\code{\link{EN_plot}()},
\code{\link{En_Market.Sumarry}()}

Other Euronext: 
\code{\link{EN_Get_News}()},
\code{\link{EN_Get_OB}()},
\code{\link{EN_HistData_bis}()},
\code{\link{EN_HistData}()},
\code{\link{EN_Overview_plot}()},
\code{\link{EN_P_Ticker_adn}()},
\code{\link{EN_Stock.Performers}()},
\code{\link{EN_Ticker_hcData}()},
\code{\link{EN_Ticker_infos}()},
\code{\link{EN_intraday_Data}()},
\code{\link{EN_plot}()}
}
\concept{Data Retrieval}
\concept{Euronext}
