/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.metaAnalysis;

import dr.inference.distribution.DistributionLikelihood;
import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.distribution.TDistributionModel;
import dr.inference.model.Parameter;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.RandomWalkOperator;
import dr.math.distributions.Distribution;
import org.ohdsi.mcmc.Runner;
import org.ohdsi.metaAnalysis.DataModel;
import org.ohdsi.metaAnalysis.HalfNormalOnStdDevPrior;
import org.ohdsi.metaAnalysis.MetaAnalysis;
import org.ohdsi.metaAnalysis.ScalePrior;
import org.ohdsi.metaAnalysis.SkewNormalDataModel;

public class RobustMetaAnalysis
extends MetaAnalysis {
    public RobustMetaAnalysis(DataModel dataModel, ScalePrior scalePrior, double muPriorSd) {
        super(dataModel, scalePrior, muPriorSd);
    }

    @Override
    protected MCMCOperator getMuOperator(Parameter mu, DistributionLikelihood likelihood, Distribution prior, double weight) {
        AdaptationMode mode = AdaptationMode.ADAPTATION_ON;
        RandomWalkOperator.BoundaryCondition condition = RandomWalkOperator.BoundaryCondition.reflecting;
        return new RandomWalkOperator(mu, null, 0.75, condition, weight, mode);
    }

    @Override
    protected ParametricDistributionModel getMuDistribution(Parameter mu, Parameter tau, boolean isPrecision) {
        return new TDistributionModel(mu, tau, (Parameter)new Parameter.Default("df", 4.0, 0.0, Double.POSITIVE_INFINITY));
    }

    public static void main(String[] args) {
        int chainLength = 1100000;
        int burnIn = 100000;
        int subSampleFrequency = 1000;
        RobustMetaAnalysis analysis = new RobustMetaAnalysis(new SkewNormalDataModel("c:/temp/skewnormal_example_3.csv"), new HalfNormalOnStdDevPrior(0.0, 2.0), 1000.0);
        Runner runner = new Runner(analysis, chainLength, burnIn, subSampleFrequency, 666.0);
        runner.run();
        runner.processSamples();
    }
}

