% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phaseDiagram2S.R
\name{phaseDiagram2S}
\alias{phaseDiagram2S}
\title{Phase Diagram for two-player games with two strategies}
\usage{
phaseDiagram2S(A, dynamic, params = NULL, vectorField = TRUE,
  strategies = c("1", "2"))
}
\arguments{
\item{A}{Numeric matrix of size 2x2 representing the number of strategies of
a symmetric matrix game.}

\item{dynamic}{Function representing an evolutionary dynamic.}

\item{params}{Numeric vector representing additional parameters for the
evolutionary dynamic.}

\item{vectorField}{Logical value that handles vector field presentation. If
set to \code{TRUE}, vector field will be shown, otherwise not. Default is
\code{TRUE}.}

\item{strategies}{String vector of length 2 that names all strategies.}
}
\value{
None.
}
\description{
Plots phase diagram of a game with two players and two
 strategies.
}
\examples{
A <- matrix(c(-1, 4, 0, 2), 2, 2, byrow=TRUE)
phaseDiagram2S(A, Replicator, strategies = c("Hawk", "Dove"))
}
\author{
Daniel Gebele \email{dngebele@gmail.com}
}
