% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_by_group_bar_graph.R
\name{prepare_by_group_bar_graph}
\alias{prepare_by_group_bar_graph}
\title{Prepares a by Group Bar Graph}
\usage{
prepare_by_group_bar_graph(df, by_var, var, stat_fun = mean,
  order_by_stat = FALSE, color = "red")
}
\arguments{
\item{df}{Data frame containing the grouping factor and the numerical variable
to be plotted}

\item{by_var}{a string containing the column name of the grouping factor}

\item{var}{a string containing the column name of the numerical variable}

\item{stat_fun}{a function to be called on the numerical variable.
Will be called with \code{na.rm = TRUE} to ignore missing values}

\item{order_by_stat}{a logical value indicating whether you want your bars to be ordered
the value of the statistic (defaults to FALSE)}

\item{color}{bar color}
}
\value{
A list containing two items:
\describe{
 \item{"df"}{A data frame containing the statistics by group}
 \item{"plot"}{The plot as returned by \code{ggplot}}
}
}
\description{
Reads a data frame containing a grouping factor and a numerical variable
and plots a bar graph of a given statistic of the variable
by the grouping factor.
}
\examples{
data(russell_3000)
graph <- prepare_by_group_bar_graph(russell_3000, "sector", "ni_sales", median)
graph$plot
}
