% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_by_group_violin_graph.R
\name{prepare_by_group_violin_graph}
\alias{prepare_by_group_violin_graph}
\title{Prepares a by Group Violin Graph}
\usage{
prepare_by_group_violin_graph(
  df,
  by_var,
  var,
  order_by_mean = FALSE,
  group_on_y = TRUE,
  ...
)
}
\arguments{
\item{df}{Data frame containing the grouping factor and the numerical variable
to be plotted}

\item{by_var}{a string containing the column name of the grouping factor}

\item{var}{a string containing the column name of the numerical variable}

\item{order_by_mean}{a logical value indicating whether you want your
violins to be ordered by group means (defaults to FALSE)}

\item{group_on_y}{a logical value indicating whether you want your
violins to be oriented horizontally (defaults to TRUE)}

\item{...}{additional parameters that are passed to
\code{\link[ggplot2]{geom_violin}}}
}
\value{
The plot as returned by \code{ggplot2}
}
\description{
Reads a data frame containing a grouping factor and a numerical variable
and plots a series of violin graphs by the grouping factor.
}
\examples{
data(russell_3000)
df <- treat_outliers(russell_3000)
prepare_by_group_violin_graph(df, "sector", "nioa")
}
