% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepapre_correlation_graph.R
\name{prepare_correlation_graph}
\alias{prepare_correlation_graph}
\title{Prepares a Correlation Graph}
\usage{
prepare_correlation_graph(df)
}
\arguments{
\item{df}{Data frame containing at least two variables that are either numeric
or logical and at least five observations.}
}
\value{
The function directly renders the graph as produced by \code{corrplot}.
In addition, it returns a list containing three items:
\describe{
 \item{"df_corr"}{A data frame containing the correlations}
 \item{"df_prob"}{A data frame containing the p-values of the correlations}
 \item{"df_n"}{A data frame containing the number of observations used for the correlations}
}
}
\description{
Reads a data frame and presents Pearson correlations above
and Spearman correlations the diagonal using a fancy graph prepared
by the package \code{corrplot}.
}
\examples{
prepare_correlation_graph(mtcars)
}
