% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutation_best.R
\name{mutation_best}
\alias{mutation_best}
\title{/best mutation for DE}
\usage{
mutation_best(X, mutpars)
}
\arguments{
\item{X}{population matrix}

\item{mutpars}{mutation parameters (see \code{Mutation parameters} for details)}
}
\value{
Matrix \code{M} containing the mutated population
}
\description{
Implements the "/best/nvecs" mutation for the ExpDE framework
}
\section{Mutation Parameters}{

The \code{mutpars} parameter contains all parameters required to define the 
mutation. \code{mutation_best()} understands the following fields in 
\code{mutpars}:
\itemize{
   \item \code{f} : scaling factor for difference vector(s).\cr
   Accepts numeric vectors of size 1 or \code{nvecs}.
   \item \code{nvecs} : number of difference vectors to use.\cr 
       Accepts \code{1 <= nvecs <= (nrow(X)/2 - 2)}\cr
       Defaults to 1.
}
}

\section{References}{

K. Price, R.M. Storn, J.A. Lampinen, "Differential Evolution: A 
Practical Approach to Global Optimization", Springer 2005
}

