% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recombination_bin.R
\name{recombination_bin}
\alias{recombination_bin}
\title{/bin recombination for DE}
\usage{
recombination_bin(X, M, recpars)
}
\arguments{
\item{X}{population matrix (original)}

\item{M}{population matrix (mutated)}

\item{recpars}{recombination parameters (see \code{Recombination parameters} 
for details)}
}
\value{
Matrix \code{U} containing the recombined population
}
\description{
Implements the "/bin" (binomial) recombination for the ExpDE framework
}
\section{Recombination Parameters}{

The \code{recpars} parameter contains all parameters required to define the 
recombination. \code{recombination_bin()} understands the following fields in 
\code{recpars}:
\itemize{
   \item \code{cr} : component-wise probability of using the value in 
                     \code{M}.\cr
                     Accepts numeric value \code{0 < cr <= 1}.
   \item \code{minchange} : logical flag to force each new candidate solution 
                            to inherit at least one component from its 
                            mutated 'parent'.\cr
                            Defaults to TRUE
}
}

\section{References}{

K. Price, R.M. Storn, J.A. Lampinen, "Differential Evolution: A 
Practical Approach to Global Optimization", Springer 2005
}

