% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bartlett.R
\name{bartlett}
\alias{bartlett}
\title{Test for Homogeneity of Variances: Bartlett}
\usage{
bartlett(trat, resp, t, r)
}
\arguments{
\item{trat}{Numeric or complex vector containing the
treatments.}

\item{resp}{Numeric or complex vector containing the
response variable.}

\item{t}{Number of treatments.}

\item{r}{Numeric or complex vector containing the number of
replications of each treatment.}
}
\value{
Returns the p-value of Bartlett's test of
homogeneity of variances and its practical interpretation
for 5\% of significance.
}
\description{
\code{bartlett} Performs the test for homogeneity of
variances of Bartlett (1937).
}
\examples{
data(ex1)
attach(ex1)
crd(trat, ig, quali = FALSE, hvar='bartlett', sigF = 0.05)
}
\references{
BARTLETT, M. S. Properties of sufficiency and
statistical tests. \emph{Proceedings of the Royal
Statistical Society - Serie A}, 60:268-282, 1937.

NOGUEIRA, D, P.; PEREIRA, G, M. Desempenho de testes para
homogeneidade de vari?ncias em delineamentos inteiramente
casualizados. \emph{Sigmae}, Alfenas, v.2, n.1, p. 7-22.
2013.
}
\seealso{
\code{\link{levene}},
\code{\link{oneillmathews}}, \code{\link{samiuddin}}
}
\author{
Eric B Ferreira, \email{eric.ferreira@unifal-mg.edu.br}

Denismar Alves Nogueira

Marcos Costa de Paula

Mateus Pimenta Siqueira Lima
}
