% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Beta.R
\name{Beta}
\alias{Beta}
\alias{dBeta}
\alias{eBeta}
\alias{iBeta}
\alias{lBeta}
\alias{pBeta}
\alias{qBeta}
\alias{rBeta}
\alias{sBeta}
\title{The Standard Beta Distribution.}
\usage{
dBeta(x, shape1 = 2, shape2 = 3, params = list(shape1, shape2), ...)

pBeta(q, shape1 = 2, shape2 = 3, params = list(shape1, shape2), ...)

qBeta(p, shape1 = 2, shape2 = 3, params = list(shape1, shape2), ...)

rBeta(n, shape1 = 2, shape2 = 3, params = list(shape1, shape2), ...)

eBeta(X, w, method = c("MOM", "numerical.MLE"), ...)

lBeta(X, w, shape1 = 2, shape2 = 3, params = list(shape1, shape2),
  logL = TRUE, ...)

sBeta(X, w, shape1 = 2, shape2 = 3, params = list(shape1, shape2), ...)

iBeta(X, w, shape1 = 2, shape2 = 3, params = list(shape1, shape2), ...)
}
\arguments{
\item{x,q}{Vector of quantiles.}

\item{shape1,shape2}{Shape parameters.}

\item{params}{A list that includes all named parameters.}

\item{...}{Additional parameters.}

\item{p}{Vector of probabilities.}

\item{n}{Number of observations.}

\item{X}{Sample observations.}

\item{w}{Optional vector of sample weights.}

\item{method}{Parameter estimation method.}

\item{logL}{logical, if TRUE lBeta gives the log-likelihood, otherwise the likelihood is given.}
}
\value{
dBeta gives the density, pBeta the distribution function,
qBeta the quantile function, rBeta generates random deviates, and
eBeta estimates the parameters. lBeta provides the log-likelihood function, sBeta the observed score function,
and iBeta the observed information matrix.
}
\description{
Density, distribution, quantile, random number
generation, and parameter estimation functions for the beta distribution with parameters \code{shape1} and \code{shape2}.
Parameter estimation can be based on a weighted or unweighted i.i.d. sample and can be carried out analytically or numerically.
}
\details{
The \code{dBeta()}, \code{pBeta()}, \code{qBeta()},and \code{rBeta()} functions serve as wrappers of the standard
\code{\link[stats]{dbeta}}, \code{\link[stats]{pbeta}}, \code{\link[stats]{qbeta}}, and \code{\link[stats]{rbeta}} functions
in the \pkg{\link{stats}} package. They allow for the shape parameters to be declared not only as
individual numerical values, but also as a list so parameter estimation can be carried out. \cr
\cr
The beta distribution with parameters \code{shape1}=\eqn{\alpha} and \code{shape2}=\eqn{\beta} is given by
\deqn{f(x) = \frac{x^{\alpha-1} (1-x)^{\beta-1}}{B(\alpha,\beta)}}
where \eqn{0 \le x \le 1}, \eqn{\alpha>0}, \eqn{\beta>0}, and \eqn{B} is the \link[base]{beta} function. \cr
\cr
Analytical parameter estimation is conducted using the method of moments. The parameter
estimates for \eqn{\alpha} and \eqn{\beta} are as given in the \href{http://www.itl.nist.gov/div898/handbook/eda/section3/eda366h.htm}{Engineering Statistics Handbook}.\cr
\cr
The log-likelihood function of the beta distribution is given by
\deqn{l(\alpha, \beta | x) = (\alpha-1)\sum_{i} ln(x_i) + (\beta-1)\sum_{i}
ln(1-x_i) - ln B(\alpha,\beta).}
Aryal & Nadarajah (2004) derived the score function and Fisher's information matrix for the 4-parameter beta function, from
which the 2-parameter cases can be obtained.
}
\examples{
# Parameter estimation for a distribution with known shape parameters
x <- rBeta(n=500, params=list(shape1=2, shape2=2))
est.par <- eBeta(x); est.par
plot(est.par)

# Fitted density curve and histogram
dens <- dBeta(x=seq(0,1,length=100), params=list(shape1=2, shape2=2))
hist(x, breaks=10, probability=TRUE, ylim = c(0,1.2*max(dens)))
lines(seq(0,1,length=100), dens, col="blue")
lines(density(x), lty=2)

# Extracting shape parameters
est.par[attributes(est.par)$par.type=="shape"]

# Parameter estimation for a distribution with unknown shape parameters
# Example from; Bury(1999) pp.253-255, parameter estimates as given by Bury are
# shape1 = 4.222 and shape2 = 6.317
data <- c(0.461, 0.432, 0.237, 0.113, 0.526, 0.278, 0.275, 0.309, 0.67, 0.428, 0.556,
0.402, 0.472, 0.226, 0.632, 0.533, 0.309, 0.417, 0.495, 0.241)
est.par <- eBeta(X=data, method="numerical.MLE"); est.par
plot(est.par)

# Log-likelihood, score function, and observed information matrix
lBeta(data, param=est.par)
sBeta(data, param=est.par)
iBeta(data, param=est.par)

# Evaluating the precision of parameter estimation by the Hessian matrix.
H <- attributes(est.par)$nll.hessian;H
var <- solve(H)
se <- sqrt(diag(var)); se
}
\author{
Haizhen Wu and A. Jonathan R. Godfrey.\cr
Updates and bug fixes by Sarah Pirikahu.
}
\references{
Johnson, N. L., Kotz, S. and Balakrishnan, N. (1995) Continuous Univariate Distributions,
 volume 2, chapter 25, Wiley, New York.\cr
 \cr
 \href{http://www.itl.nist.gov/div898/handbook/eda/section3/eda366h.htm}{Engineering Statistics Handbook}\cr
 \cr
 Bury, K. (1999) Statistical Distributions in Engineering, Chapter 14, pp.253-255,
 Cambridge University Press.\cr
 \cr
 Aryal, G. and Nadarajah, S. (2004) Information Matrix for Beta Distributions, Serdica Math. J. 30, 513-526.
}
\seealso{
\pkg{\link{ExtDist}} for other standard distributions.
}

