% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{dataCorrection}
\alias{dataCorrection}
\title{Data correction for natural abundance of 13C and data normalization using
internal standards followed by blank substraction.}
\usage{
dataCorrection(
  fadata,
  correct13C = TRUE,
  blankgroup = "blank",
  externalnormalization = c(),
  resolution = 140000,
  purity13C = 0.99,
  verbose = TRUE
)
}
\arguments{
\item{fadata}{fadata list.}

\item{correct13C}{logical. If TRUE, data is corrected for natural abundance
of 13C. Set to FALSE if data has been already been corrected.}

\item{blankgroup}{name used to define blank samples group.}

\item{externalnormalization}{column name at the metadata data frame of any
additional measure that must be used to normalize data (i.e. protein).}

\item{resolution}{resolution of the mass spectrometer.}

\item{purity13C}{purity of the tracer employed.}

\item{verbose}{print information messages.}
}
\value{
corrected fadata.
}
\description{
Data correction for natural abundance of 13C and data normalization using
internal standards followed by blank substraction.
}
\examples{
\donttest{
ssdata <- dataCorrection(ssexamplefadata, blankgroup="Blank")
}

}
\references{
Su X, Lu W, Rabinowitz J (2017). Metabolite Spectral Accuracy on 
Orbitraps. Analytical Chemistry, 89(11), 5940-5948, PMID: 28471646, R package 
version 0.2.4 (2021), <https://doi.org/10.1021/acs.analchem.7b00396>.
}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
