% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VapPres.R
\name{SlpSVPC}
\alias{SlpSVPC}
\title{Slope of Saturation Vapour Pressure Curve (Delta)}
\usage{
SlpSVPC(Temp)
}
\arguments{
\item{Temp}{A numeric scalar that denotes the air temperature [C].}
}
\value{
The function returns the value of the slope of saturation vapour pressure curve at air temperature \code{Temp} as a numeric scalar.
}
\description{
\code{SlpSVPC} returns the value of slope of saturation vapour pressure curve at a specific air temperature.
}
\details{
This is a function to calculate the slope of saturation vapour pressure curve at the air temperature \code{Temp} [kPa/C].
}
\section{Reference}{

\href{https://www.fao.org/3/x0490E/x0490e00.htm}{Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998).
   \emph{Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56}.
   Fao, Rome, 300(9), D05109.}
}

\examples{
SlpSVPC(Temp = 25)

}
\seealso{
\code{\link{SatVP}}.
}
