% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_blocks.R
\name{multiple_blocks}
\alias{multiple_blocks}
\title{Multi-level Dynamic Factor Model - Multiple Blocks (MLDFM)}
\usage{
multiple_blocks(
  data,
  global,
  local,
  middle_layer,
  block_ind,
  tol,
  max_iter,
  method
)
}
\arguments{
\item{data}{A numeric matrix or data frame containing the time series data (T × N).}

\item{global}{Integer. Number of global factors extracted from the entire dataset.}

\item{local}{Integer vector of length \code{blocks}. Specifies the number of local factors for each block.}

\item{middle_layer}{Named list. Each name is a string specifying a group of blocks (e.g., \code{"1-3"} or \code{"2-3"}), and each value is the number of factors to extract.}

\item{block_ind}{Integer vector. End column indices for each block. Must be of length \code{blocks} and in increasing order.}

\item{tol}{Numeric. The tolerance level for the residual sum of squares (RSS) minimization process. Used as a convergence criterion.}

\item{max_iter}{Integer. The maximum number of iterations allowed for the RSS minimization process.}

\item{method}{Integer.  Method used to initialize the factors: \code{0} for Canonical Correlation Analysis (CCA), \code{1} for Principal Component Analysis (PCA).}
}
\value{
A list with elements:
\describe{
\item{factors}{Matrix of estimated factors.}
\item{loadings}{Matrix of factor loadings.}
\item{residuals}{Matrix of residuals.}
\item{fitted}{Matrix of fitted values.}
\item{method}{Initialization method used (CCA or PCA).}
\item{iterations}{Number of iterations before convergence.}
\item{factors_list}{List of estimated factors for each node.}
}
}
\description{
Estimates a Multi-Level Dynamic Factor Model (MLDFM) using Sequential Least Squares Estimation approach
}
\keyword{internal}
