% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{time_weights}
\alias{time_weights}
\title{Compute a normalized weighting vector based on a vector of sampling times.}
\usage{
time_weights(times, group = NULL)
}
\arguments{
\item{times}{A numeric vector of sampling times. Each entry must be
greater than the previous entry.}

\item{group}{Optional; a character vector specifying the group identity of each
sampling time. Use if there are samples from multiple replicates or subjects
in one dataset.}
}
\value{
A numeric vector. Each entry provides a weight for each entry in the
provided \code{times} vector. If \code{group} is not specified, the vector sums to 1. If
\code{group} is specified, the vector sums to the number of distinct groups.
}
\description{
This function takes a vector of sampling times, \eqn{t = (t_1, t_2, \ldots, t_I)}{latex}
and computes a normalized vector which can be used to weight each sample based on
the time between the subsequent and the preceding samples. The weighting vector \eqn{w}
is defined such that each entry, \eqn{w_i = d_i / 2T}, where \eqn{T=t_I - t_1} and
\eqn{d_i = t_{i+1} - t_{i-1}} for \eqn{i} not equal to 1 or I. \eqn{d_1 = t_2-t_1} and \eqn{d_I = t_I-t_{I-1}}.
}
\examples{
time_vector = c(1, 8, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
                32, 33, 34, 35, 36, 37, 38, 39, 44, 50, 57, 64)

time_weights(times = time_vector)
}
