% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ar2ma.R
\name{ar2ma}
\alias{ar2ma}
\title{ar2ma}
\usage{
ar2ma(ar, p, n = 11, CharValue = TRUE)
}
\arguments{
\item{ar}{AR coefficients matrix which is k x kp dimension, k is numbers of variables,
and no constant.}

\item{p}{lags orders of AR.}

\item{n}{lags orders of MA generated.}

\item{CharValue}{logical value, whether compute character value.}
}
\value{
a matrix which is MA coefficients.
}
\description{
Convert auto regression (AR) coefficients to moving average (MA) coefficients
}
\details{
the formula is,
\deqn{A_s = F_1 * A_{s-1} + F_2 * A_{s-2} + ... + F_p * A_{s-p}}
where A is MA coefficients, F is AR coefficients.
}
\examples{
require(vars)
data(Canada)
ar <- Bcoef(VAR(Canada, p = 2, type = "none"))
ar
ar2ma(ar, p = 2)
}
