% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FCVAR_post.R
\name{MVWNtest}
\alias{MVWNtest}
\title{Multivariate White Noise Tests}
\usage{
MVWNtest(x, maxlag, printResults)
}
\arguments{
\item{x}{A matrix of variables to be included in the system,
typically model residuals.}

\item{maxlag}{The number of lags for serial correlation tests.}

\item{printResults}{An indicator to print results to screen.}
}
\value{
An S3 object of type \code{MVWN_stats} containing the test results,
including the following parameters:
\describe{
  \item{\code{Q}}{A 1xp vector of Q statistics for individual series.}
  \item{\code{pvQ}}{A 1xp vector of P-values for Q-test on individual series.}
  \item{\code{LM}}{A 1xp vector of LM statistics for individual series.}
  \item{\code{pvLM}}{A 1xp vector of P-values for LM-test on individual series.}
  \item{\code{mvQ}}{A multivariate Q statistic.}
  \item{\code{pvMVQ}}{A p-value for multivariate Q-statistic using \code{p^2*maxlag}
  degrees of freedom.}
  \item{\code{maxlag}}{The number of lags for serial correlation tests.}
  \item{\code{p}}{The number of variables in the system.}
}
}
\description{
\code{MVWNtest} performs multivariate tests for white noise.
It performs both the Ljung-Box Q-test and the LM-test on individual series
for a sequence of lag lengths.
\code{summary.MVWN_stats} prints a summary of these statistics to screen.
}
\note{
The LM test is consistent for heteroskedastic series; the Q-test is not.
}
\examples{
\donttest{
opt <- FCVARoptions()
opt$gridSearch   <- 0 # Disable grid search in optimization.
opt$dbMin        <- c(0.01, 0.01) # Set lower bound for d,b.
opt$dbMax        <- c(2.00, 2.00) # Set upper bound for d,b.
opt$constrained  <- 0 # Impose restriction dbMax >= d >= b >= dbMin ? 1 <- yes, 0 <- no.
x <- votingJNP2014[, c("lib", "ir_can", "un_can")]
results <- FCVARestn(x, k = 2, r = 1, opt)
MVWNtest_stats <- MVWNtest(x = results$Residuals, maxlag = 12, printResults = 1)
}
set.seed(27)
WN <- stats::rnorm(100)
RW <- cumsum(stats::rnorm(100))
MVWN_x <- as.matrix(data.frame(WN = WN, RW = RW))
MVWNtest_stats <- MVWNtest(x = MVWN_x, maxlag = 10, printResults = 1)
}
\seealso{
\code{FCVARoptions} to set default estimation options.
\code{FCVARestn} produces the residuals intended for this test.
\code{LagSelect} uses this test as part of the lag order selection process.
\code{summary.MVWN_stats} prints a summary of the \code{MVWN_stats} statistics to screen.

Other FCVAR postestimation functions: 
\code{\link{FCVARboot}()},
\code{\link{FCVARhypoTest}()},
\code{\link{GetCharPolyRoots}()},
\code{\link{plot.FCVAR_roots}()},
\code{\link{summary.FCVAR_roots}()},
\code{\link{summary.MVWN_stats}()}
}
\concept{FCVAR postestimation functions}
