% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FCVAR_post.R
\name{summary.FCVAR_roots}
\alias{summary.FCVAR_roots}
\title{Print Summary of Roots of the Characteristic Polynomial}
\usage{
\method{summary}{FCVAR_roots}(object, ...)
}
\arguments{
\item{object}{An S3 object of type \code{FCVAR_roots} with the following elements:
\describe{
  \item{\code{cPolyRoots}}{A vector of the roots of the characteristic polynomial.
    It is an element of the list of estimation \code{results} output from \code{FCVARestn}.}
  \item{\code{b}}{A numeric value of the fractional cointegration parameter.}
}}

\item{...}{additional arguments affecting the summary produced.}
}
\description{
\code{summary.FCVAR_roots} prints the output of
\code{GetCharPolyRoots} to screen.
\code{GetCharPolyRoots} calculates the roots of the
characteristic polynomial to plot them with the unit circle
transformed for the fractional model, see Johansen (2008).
}
\note{
The roots are calculated from the companion form of the VAR,
where the roots are given as the inverse eigenvalues of the
coefficient matrix.
}
\examples{
\donttest{
opt <- FCVARoptions()
opt$gridSearch   <- 0 # Disable grid search in optimization.
opt$dbMin        <- c(0.01, 0.01) # Set lower bound for d,b.
opt$dbMax        <- c(2.00, 2.00) # Set upper bound for d,b.
opt$constrained  <- 0 # Impose restriction dbMax >= d >= b >= dbMin ? 1 <- yes, 0 <- no.
x <- votingJNP2014[, c("lib", "ir_can", "un_can")]
results <- FCVARestn(x, k = 2, r = 1, opt)
FCVAR_CharPoly <- GetCharPolyRoots(results$coeffs, opt, k = 2, r = 1, p = 3)
summary(object = FCVAR_CharPoly)
graphics::plot(x = FCVAR_CharPoly)
}
}
\references{
Johansen, S. (2008). "A representation theory for a class of
vector autoregressive models for fractional processes,"
Econometric Theory 24, 651-676.
}
\seealso{
\code{FCVARoptions} to set default estimation options.
\code{FCVARestn} to estimate the model for which to calculate the roots
of the characteristic polynomial.
\code{summary.FCVAR_roots} prints the output of
\code{GetCharPolyRoots} to screen.

Other FCVAR postestimation functions: 
\code{\link{FCVARboot}()},
\code{\link{FCVARhypoTest}()},
\code{\link{GetCharPolyRoots}()},
\code{\link{MVWNtest}()},
\code{\link{plot.FCVAR_roots}()},
\code{\link{summary.MVWN_stats}()}
}
\concept{FCVAR postestimation functions}
