% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{kernel}
\alias{kernel}
\alias{kernel_DLR_fast}
\alias{kernel_DLR_crit}
\alias{kernel_DGR_fast}
\alias{kernel_DGR_crit}
\alias{kernel_DPB_fast}
\alias{kernel_DPB_crit}
\alias{kernel_wLR_fast}
\alias{kernel_wGR_fast}
\alias{kernel_wPB_fast}
\title{Kernel functions}
\usage{
kernel_DLR_fast(
  pCDFlist,
  pvalues,
  adaptive = TRUE,
  alpha = 0.05,
  stepUp = FALSE,
  zeta = 0.5,
  support = 0L
)

kernel_DLR_crit(
  pCDFlist,
  pvalues,
  sorted_pv,
  adaptive = TRUE,
  alpha = 0.05,
  zeta = 0.5,
  stepUp = FALSE
)

kernel_DGR_fast(pCDFlist, pvalues, adaptive = TRUE, alpha = 0.05)

kernel_DGR_crit(
  pCDFlist,
  pvalues,
  sorted_pv,
  adaptive = TRUE,
  alpha = 0.05,
  zeta = 0.5
)

kernel_DPB_fast(pCDFlist, pvalues, adaptive = TRUE, alpha = 0.05, exact = TRUE)

kernel_DPB_crit(
  pCDFlist,
  pvalues,
  sorted_pv,
  adaptive = TRUE,
  alpha = 0.05,
  zeta = 0.5,
  exact = TRUE
)

kernel_wLR_fast(qvalues, weights, alpha = 0.05, geom_weighting = FALSE)

kernel_wGR_fast(qvalues, weights, alpha = 0.05, geom_weighting = FALSE)

kernel_wPB_fast(
  qvalues,
  weights,
  alpha = 0.05,
  geom_weighting = FALSE,
  exact = TRUE
)
}
\arguments{
\item{pCDFlist}{a list of the supports of the CDFs of the p-values. Each support is represented by a vector that must be in increasing order.}

\item{pvalues}{a numeric vector. Contains all values of the p-values supports if we search for the critical constants. If not, contains only the observed p-values. Must be sorted in increasing order!}

\item{adaptive}{a boolean specifying whether to conduct an adaptive procedure or not.}

\item{alpha}{the target FDP, a number strictly between 0 and 1. For \code{*.fast} kernels, it is only necessary, if \code{stepUp = TRUE}.}

\item{stepUp}{a numeric vector. Identical to \code{pvalues} for a step-down procedure. Equals \code{c.m} for a step-up procedure.}

\item{zeta}{the target probability of not exceeding the desired FDP, a number strictly between 0 and 1. If \code{zeta=NULL} (the default), then \code{zeta} is chosen equal to \code{alpha}.}

\item{support}{a numeric vector. Contains all values of the p-values supports. Ignored, if \code{stepUp = FALSE}. Must be sorted in increasing order!}

\item{sorted_pv}{a vector of observed p-values, in increasing order.}

\item{exact}{a boolean specifying whether to compute the Poisson-Binomial distribution exactly or by a normal approximation.}

\item{qvalues}{a numeric vector. Contains weighted raw p-values.}

\item{weights}{a numeric vector. Contains the weights of the p-values.}

\item{geom_weighting}{a boolean specifying whether to conduct geometric
(\code{TRUE}) or arithmetic (\code{FALSE})
weighting.}
}
\value{
For ".fast" kernels, a vector of transformed p-values is returned; ".crit"
kernels return a list object with critical constants (\code{$crit.consts})
and transformed p-values (\code{$pval.transf}).
}
\description{
Kernel functions transform observed p-values or their support according to
[HLR], [PB] and [HGR]. The output is used by \code{\link{discrete.LR}},
\code{\link{discrete.PB}} and \code{\link{discrete.GR}}, respectively.
For each procedure, there is a kernel for fast computation and one for
calculation of critical values. Kernels followed by ".crit", e.g.
\code{kernel.DGR.crit}, compute and return these critical values, while
kernels ending in ".fast" only transform p-values and are therefore faster.
The end user should not use these functions directly.
}
\examples{
X1 <- c(4, 2, 2, 14, 6, 9, 4, 0, 1)
X2 <- c(0, 0, 1, 3, 2, 1, 2, 2, 2)
N1 <- rep(148, 9)
N2 <- rep(132, 9)
Y1 <- N1 - X1
Y2 <- N2 - X2
df <- data.frame(X1, Y1, X2, Y2)
df

# Construction of the p-values and their supports (fisher.pvalues.support
# is from 'DiscreteFDR' package!)
df.formatted <- fisher.pvalues.support(counts = df, input = "noassoc")
raw.pvalues <- df.formatted$raw
pCDFlist <- df.formatted$support

alpha <- 0.05

# If not searching for critical constants, we use only the observed p-values
sorted.pvals <- sort(raw.pvalues)
y.DLR.fast <- kernel_DLR_fast(pCDFlist, sorted.pvals, TRUE)
y.NDGR.fast <- kernel_DGR_fast(pCDFlist, sorted.pvals, FALSE)
# transformed values
y.DLR.fast
y.NDGR.fast

# compute support
pv.list <- sort(unique(unlist(pCDFlist)))
y.DGR.crit <- kernel_DGR_crit(pCDFlist, pv.list, sorted.pvals, TRUE)
y.NDPB.crit <- kernel_DPB_crit(pCDFlist, pv.list, sorted.pvals, FALSE)
# critical constants
y.DGR.crit$crit.consts
y.NDPB.crit$crit.consts
# transformed values
y.DGR.crit$pval.transf
y.NDPB.crit$pval.transf

}
\seealso{
\code{\link{FDX-package}}, \code{\link{discrete.LR}}
\code{\link{discrete.GR}}, \code{\link{discrete.PB}},
\code{\link{weighted.LR}}, \code{\link{weighted.GR}},
\code{\link{discrete.PB}}
}
