% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_funs.R
\name{hist.FDX}
\alias{hist.FDX}
\title{Histogram of Raw P-Values}
\usage{
\method{hist}{FDX}(x, breaks = "FD", mode = c("raw", "selected", "weighted"), ...)
}
\arguments{
\item{x}{object of class \code{FDX}.}

\item{breaks}{as in \code{\link[graphics:hist]{graphics::hist()}}; here, the Friedman-Diaconis
algorithm (\code{"FD"}) is used as default.}

\item{mode}{single character string specifying for which $p$-values the
histogram is to be generated; must be one of \code{"raw"},
\code{"selected"} or \code{"weighted"}.}

\item{...}{further arguments to \code{\link[graphics:hist]{graphics::hist()}} or
\code{\link[graphics:plothistogram]{graphics::plot.histogram()}}, respectively.}
}
\value{
An object of class \code{histogram}.
}
\description{
Computes a histogram of the raw p-values of a \code{FDX} object.
}
\details{
If \code{x} does not contain results of a weighting or selection approach, a
warning is issued and a histogram of the raw p-values is drawn.
}
\examples{
X1 <- c(4, 2, 2, 14, 6, 9, 4, 0, 1)
X2 <- c(0, 0, 1, 3, 2, 1, 2, 2, 2)
N1 <- rep(148, 9)
N2 <- rep(132, 9)
Y1 <- N1 - X1
Y2 <- N2 - X2
df <- data.frame(X1, Y1, X2, Y2)
df

# Construction of the p-values and their supports with Fisher's exact test
library(DiscreteTests)  # for Fisher's exact test
test.results <- fisher_test_pv(df)
raw.pvalues <- test.results$get_pvalues()
pCDFlist <- test.results$get_pvalue_supports()

# DGR
DGR <- DGR(raw.pvalues, pCDFlist)
# histogram of raw p-values
hist(DGR)

# arithmetic-weighted GR (using 1 - raw.pvalues as weights)
wGR <- wGR.AM(raw.pvalues, 1 - raw.pvalues)
# histogram of raw p-values
hist(wGR)
# histogram of weighted p-values
hist(wGR, mode = "weighted")

}
