% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CATE.R
\name{CATE}
\alias{CATE}
\title{Get the Size and CATE of Matched Group(s)}
\usage{
CATE(FLAME_object, num_covs = NULL, cov_name = NULL, cov_val = NULL)
}
\arguments{
\item{FLAME_object}{object returned by applying the FLAME algorithm
(\code{\link{FLAME_bit}} or \code{\link{FLAME_PostgreSQL}} or
\code{\link{FLAME_SQLite}})}

\item{num_covs}{number of covariates used for matching}

\item{cov_name}{a vector of covariate names}

\item{cov_val}{a vector of covariate values, where the value position should
match cov_name position. In addition, it has to be in character R data
type.}
}
\value{
data frame with covariate values, CATE, and size of each matched
  group
}
\description{
\code{CATE} provides detailed information of the conditional average treatment effect (CATE)
and size of each matched group. First, given number of covariates used for matching,
\code{CATE(FLAME_object, num_covs = x)} returns the covariate values, size
and CATE of each matched group. Second, given a covariate combination,
\code{CATE(FLAME_object, num_covs = x, cov_name = c("x1", "x2", ...), cov_val = c(0,1,...))}
returns the CATE and size of the matched group. Third, if user would like to see all
matched groups given a specific covariate combination even when the FLAME
algorithm performs matching with more than the number of covariates
specified, \code{CATE(FLAME_object, cov_name = c("x1", "x2", ...), cov_val =
c(0,1,...))} returns all matched groups containing the covariate combination.
}
\examples{
\donttest{
data(toy_data)
result <- FLAME::FLAME_bit(data = toy_data, holdout = toy_data)
FLAME::CATE(FLAME_object = result, num_covs  = 2)
FLAME::CATE(FLAME_object = result, num_covs  = 2, cov_name = c("X1", "X2"), cov_val = c("2", "2"))
FLAME::CATE(FLAME_object = result, cov_name = c("X1", "X2"), cov_val = c("2", "2"))
}
}
