% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_lfreg.R
\name{predict.lfreg}
\alias{predict.lfreg}
\title{Predict LFREG model}
\usage{
\method{predict}{lfreg}(object, ..., newdata = NULL, type = c("probabilities", "labels"))
}
\arguments{
\item{object}{LFREG model for which predictions are computed}

\item{...}{additional arguments relevant for the generic method}

\item{newdata}{an optional argument. Newdata should be organized as a list. The elements of the list
are covariates from LFREG model, respectively. No data transformation is needed. Thus, functional covariates are entered in the list \code{newdata}
in their raw form. The \code{predict.lfreg} function will take care of the transformation of such covariates into the functional form of their equivalents from LFREG model.}

\item{type}{c("probabilities", "labels")}
}
\value{
predictions of dependent variable \code{y}
}
\description{
Prediction of LFREG model
}
\examples{
library(fda)
precipitation_data = CanadianWeather$daily[1:334,,"Precipitation.mm"]
annualprec = apply(precipitation_data,2,sum) # without December
y = ifelse(annualprec<mean(annualprec), 0, 1)
y = as.factor(y)
x = CanadianWeather$daily[1:334,,"Temperature.C"]
xbasis = create.fourier.basis(c(1,334),5) # 5 basis functions
xfd = smooth.basis(c(1:334),x,xbasis)$fd
bbasis = create.fourier.basis(c(0,334),5)
betalist = list(bbasis)
formula = y ~ xfd
lfreg.model = lfreg(formula, betalist = betalist)
# Prediction on new data
newdata = list(CanadianWeather$dailyAv[1:365,,1])
# newdata = list(xfd_1, latitude, longitude)
yhat = predict(lfreg.model, newdata = newdata, type = "labels")

}
