context("depletion() OUTPUT")

test_that("depletion() output types",{
  data(SMBassLS)
  l1 <- depletion(SMBassLS$catch,SMBassLS$effort,method="Leslie")
  expect_is(l1,"depletion")
  # coef()s
  l1A <- coef(l1)
  expect_true(is.vector(l1A))
  expect_is(l1A,"numeric")
  expect_equal(length(l1A),2)
  expect_equal(names(l1A),c("No","q"))
  l1A <- coef(l1,parm="No")
  expect_true(is.vector(l1A))
  expect_is(l1A,"numeric")
  expect_equal(length(l1A),1)
  expect_equal(names(l1A),c("No"))
  l1A <- coef(l1,parm="lm")
  expect_true(is.vector(l1A))
  expect_is(l1A,"numeric")
  expect_equal(length(l1A),2)
  expect_equal(names(l1A),c("(Intercept)","K"))
  # confint()s
  l1A <- confint(l1)
  expect_true(is.matrix(l1A))
  expect_equal(mode(l1A),"numeric")
  expect_equal(nrow(l1A),2)
  expect_equal(ncol(l1A),2)
  expect_equal(rownames(l1A),c("No","q"))
  expect_equal(colnames(l1A),c("95% LCI","95% UCI"))
  l1A <- confint(l1,parm="No")
  expect_true(is.matrix(l1A))
  expect_equal(mode(l1A),"numeric")
  expect_equal(ncol(l1A),2)
  expect_equal(nrow(l1A),1)
  expect_equal(rownames(l1A),c("No"))
  expect_equal(colnames(l1A),c("95% LCI","95% UCI"))
  l1A <- confint(l1,parm="lm")
  expect_true(is.matrix(l1A))
  expect_equal(mode(l1A),"numeric")
  expect_equal(nrow(l1A),2)
  expect_equal(ncol(l1A),2)
  expect_equal(rownames(l1A),c("(Intercept)","K"))
  expect_equal(colnames(l1A),c("95% LCI","95% UCI"))
  # summary()s
  l1A <- summary(l1)
  expect_true(is.matrix(l1A))
  expect_equal(mode(l1A),"numeric")
  expect_equal(nrow(l1A),2)
  expect_equal(ncol(l1A),2)
  expect_equal(rownames(l1A),c("No","q"))
  expect_equal(colnames(l1A),c("Estimate","Std. Err."))
  l1A <- summary(l1,parm="No")
  expect_true(is.matrix(l1A))
  expect_equal(mode(l1A),"numeric")
  expect_equal(nrow(l1A),1)
  expect_equal(ncol(l1A),2)
  expect_equal(rownames(l1A),c("No"))
  expect_equal(colnames(l1A),c("Estimate","Std. Err."))
  l1A <- summary(l1,parm="lm")
  expect_equal(class(l1A),"summary.lm")
  expect_equal(mode(l1A),"list")
  # anova()s
  l1A <- anova(l1)
  expect_equal(class(l1A),c("anova","data.frame"))
  expect_equal(mode(l1A),"list")
  
  d1 <- depletion(SMBassLS$catch,SMBassLS$effort,method="DeLury")
  expect_is(d1,"depletion")
  # coef()s
  d1A <- coef(d1)
  expect_true(is.vector(d1A))
  expect_is(d1A,"numeric")
  expect_equal(length(d1A),2)
  expect_equal(names(d1A),c("No","q"))
  d1A <- coef(d1,parm="No")
  expect_true(is.vector(d1A))
  expect_is(d1A,"numeric")
  expect_equal(length(d1A),1)
  expect_equal(names(d1A),c("No"))
  d1A <- coef(d1,parm="lm")
  expect_true(is.vector(d1A))
  expect_is(d1A,"numeric")
  expect_equal(length(d1A),2)
  # confint()s
  d1A <- confint(d1)
  expect_true(is.matrix(d1A))
  expect_equal(mode(d1A),"numeric")
  expect_equal(nrow(d1A),2)
  expect_equal(ncol(d1A),2)
  expect_equal(rownames(d1A),c("No","q"))
  expect_equal(colnames(d1A),c("95% LCI","95% UCI"))
  d1A <- confint(d1,parm="No")
  expect_true(is.matrix(d1A))
  expect_equal(mode(d1A),"numeric")
  expect_equal(length(d1A),2)
  expect_equal(rownames(d1A),c("No"))
  expect_equal(colnames(d1A),c("95% LCI","95% UCI"))
  d1A <- confint(d1,parm="lm")
  expect_true(is.matrix(d1A))
  expect_equal(mode(d1A),"numeric")
  expect_equal(nrow(d1A),2)
  expect_equal(ncol(d1A),2)
  expect_equal(colnames(d1A),c("95% LCI","95% UCI"))
  # summary()s
  d1A <- summary(d1)
  expect_true(is.matrix(d1A))
  expect_equal(mode(d1A),"numeric")
  expect_equal(nrow(d1A),2)
  expect_equal(ncol(d1A),2)
  expect_equal(rownames(d1A),c("No","q"))
  expect_equal(colnames(d1A),c("Estimate","Std. Err."))
  d1A <- summary(d1,parm="No")
  expect_true(is.matrix(d1A))
  expect_equal(mode(d1A),"numeric")
  expect_equal(nrow(d1A),1)
  expect_equal(ncol(d1A),2)
  expect_equal(rownames(d1A),c("No"))
  expect_equal(colnames(d1A),c("Estimate","Std. Err."))
  d1A <- summary(d1,parm="lm")
  expect_equal(class(d1A),"summary.lm")
  expect_equal(mode(d1A),"list")
  # anova()s
  d1A <- anova(d1)
  expect_equal(class(d1A),c("anova","data.frame"))
  expect_equal(mode(d1A),"list")
})
