context("PSD functions OUTPUT")
source("EXS_PSD.R")

test_that("psdVal() returns",{
  ## check values for yellow perch
  tmp <- psdVal("Yellow Perch",incl.zero=FALSE)
  expect_equivalent(tmp,c(130,200,250,300,380))
  expect_equal(names(tmp),c("stock","quality","preferred","memorable","trophy" ))
  tmp <- psdVal("Yellow Perch",incl.zero=FALSE,units="in")
  expect_equivalent(tmp,c(5,8,10,12,15))
  expect_equal(names(tmp),c("stock","quality","preferred","memorable","trophy" ))
  tmp <- psdVal("Yellow Perch",units="in")
  expect_equivalent(tmp,c(0,5,8,10,12,15))
  expect_equal(names(tmp),c("substock","stock","quality","preferred","memorable","trophy" ))
  tmp <- psdVal("Yellow Perch",units="in",addLens=c(7,9))
  expect_equivalent(tmp,c(0,5,7,8,9,10,12,15))
  expect_equal(names(tmp),c("substock","stock","7","quality","9","preferred","memorable","trophy" ))
  tmp <- psdVal("Yellow Perch",units="in",addLens=c(7,9),addNames=c("minSlot","maxSlot"))
  expect_equivalent(tmp,c(0,5,7,8,9,10,12,15))
  expect_equal(names(tmp),c("substock","stock","minSlot","quality","maxSlot","preferred","memorable","trophy"))
  tmp <- psdVal("Yellow Perch",units="in",addLens=c(minSlot=7,maxSlot=9),addNames=c("minSlot","maxSlot"))
  expect_equivalent(tmp,c(0,5,7,8,9,10,12,15))
  expect_equal(names(tmp),c("substock","stock","minSlot","quality","maxSlot","preferred","memorable","trophy"))
  tmp <- psdVal("yellow perch")
  expect_equivalent(tmp,c(0,130,200,250,300,380))
  expect_equal(names(tmp),c("substock","stock","quality","preferred","memorable","trophy"))
})

test_that("psdCI() returns",{
  n <- 997
  ipsd <- c(130,491,253,123)/n
  ## single binomial
  tmp <- psdCI(c(0,0,1,1),ipsd,n=n)
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),3)
  expect_equal(colnames(tmp),c("Estimate","95% LCI","95% UCI"))
  tmp <- psdCI(c(1,0,0,0),ipsd,n=n,label="PSD S-Q")
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),3)
  expect_equal(colnames(tmp),c("Estimate","95% LCI","95% UCI"))
  expect_equal(rownames(tmp),"PSD S-Q")
  ## single multinomial
  tmp <- psdCI(c(0,0,1,1),ipsd,n=n,method="multinomial")
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),3)
  expect_equal(colnames(tmp),c("Estimate","95% LCI","95% UCI"))
  tmp <- psdCI(c(1,0,0,0),ipsd,n=n,method="multinomial",label="PSD S-Q")
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),3)
  expect_equal(colnames(tmp),c("Estimate","95% LCI","95% UCI"))
  expect_equal(rownames(tmp),"PSD S-Q")
  ## Adjustment for not proportions
  ipsd <- c(130,491,253,123)
  n <- sum(ipsd)
  ipsd2 <- ipsd/n
  tmp <- suppressWarnings(psdCI(c(0,0,1,1),ipsd,n=n))
  tmp2 <- psdCI(c(0,0,1,1),ipsd2,n=n)
  expect_equal(tmp,tmp2)
  tmp <- suppressWarnings(psdCI(c(0,0,1,1),ipsd,n=n,method="multinomial"))
  tmp2 <- psdCI(c(0,0,1,1),ipsd2,n=n,method="multinomial")
  expect_equal(tmp,tmp2)
  ## Adjustment for a PSD of 0 or 1
  ipsd <- c(1,0,0,0)
  n <- 455
  tmp <- psdCI(c(1,1,0,0),ipsd,n=n)
  expect_equivalent(tmp,matrix(c(100,NA,NA),nrow=1))
  ipsd <- c(0,0,0,1)
  n <- 455
  tmp <- psdCI(c(1,1,0,0),ipsd,n=n)
  expect_equivalent(tmp,matrix(c(0,NA,NA),nrow=1))
})  

test_that("psdCalc() returns",{
  ## All values
  tmp <- suppressWarnings(psdCalc(~tl,data=df,species="Yellow perch"))
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),8)
  expect_equal(ncol(tmp),3)
  expect_equal(rownames(tmp),c("PSD-Q","PSD-P","PSD-M","PSD-T","PSD S-Q","PSD Q-P","PSD P-M","PSD M-T"))
  expect_equal(colnames(tmp),c("Estimate","95% LCI","95% UCI"))
  ## Traditional values
  tmp <- suppressWarnings(psdCalc(~tl,data=df,species="Yellow perch",what="traditional"))
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),4)
  expect_equal(ncol(tmp),3)
  expect_equal(rownames(tmp),c("PSD-Q","PSD-P","PSD-M","PSD-T"))
  expect_equal(colnames(tmp),c("Estimate","95% LCI","95% UCI"))
  tmp <- suppressWarnings(psdCalc(~tl,data=df,species="Yellow perch"))
  ## Incremental values
  tmp <- suppressWarnings(psdCalc(~tl,data=df,species="Yellow perch",what="incremental"))
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),4)
  expect_equal(ncol(tmp),3)
  expect_equal(rownames(tmp),c("PSD S-Q","PSD Q-P","PSD P-M","PSD M-T"))
  expect_equal(colnames(tmp),c("Estimate","95% LCI","95% UCI"))
  ## All values, but don't drop 0s
  tmp <- suppressWarnings(psdCalc(~tl,data=df,species="Yellow perch",drop0Est=FALSE))
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),8)
  expect_equal(ncol(tmp),3)
  expect_equal(rownames(tmp),c("PSD-Q","PSD-P","PSD-M","PSD-T","PSD S-Q","PSD Q-P","PSD P-M","PSD M-T"))
  expect_equal(colnames(tmp),c("Estimate","95% LCI","95% UCI"))
  ## All values, with some additional lengths
  tmp <- suppressWarnings(psdCalc(~tl,data=df,species="Yellow perch",addLens=225,addNames="Derek"))
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),10)
  expect_equal(ncol(tmp),3)
  expect_equal(rownames(tmp),c("PSD-Q","PSD-Derek","PSD-P","PSD-M","PSD-T","PSD S-Q","PSD Q-Derek","PSD Derek-P","PSD P-M","PSD M-T"))
  expect_equal(colnames(tmp),c("Estimate","95% LCI","95% UCI"))
  ## All values, with some additional lengths but no names
  tmp <- suppressWarnings(psdCalc(~tl,data=df,species="Yellow perch",addLens=c(225,245),drop0Est=FALSE))
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),12)
  expect_equal(ncol(tmp),3)
  expect_equal(rownames(tmp),c("PSD-Q","PSD-225","PSD-245","PSD-P","PSD-M","PSD-T","PSD S-Q","PSD Q-225","PSD 225-245","PSD 245-P","PSD P-M","PSD M-T"))
  expect_equal(colnames(tmp),c("Estimate","95% LCI","95% UCI"))
  ## Just the additional values
  tmp <- suppressWarnings(psdCalc(~tl,data=df,species="Yellow perch",addLens=c(225,245),drop0Est=FALSE,justAdds=TRUE))
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),5)
  expect_equal(ncol(tmp),3)
  expect_equal(rownames(tmp),c("PSD-225","PSD-245","PSD Q-225","PSD 225-245","PSD 245-P"))
  expect_equal(colnames(tmp),c("Estimate","95% LCI","95% UCI"))
  ## All values, but df only has values greater than stock values
  df1 <- filterD(df,tl>=130)
  tmp <- suppressWarnings(psdCalc(~tl,data=df1,species="Yellow perch"))
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),8)
  expect_equal(ncol(tmp),3)
  expect_equal(rownames(tmp),c("PSD-Q","PSD-P","PSD-M","PSD-T","PSD S-Q","PSD Q-P","PSD P-M","PSD M-T"))
  expect_equal(colnames(tmp),c("Estimate","95% LCI","95% UCI"))
  ## All values, but df only has values greater than quality values
  df1 <- filterD(df,tl>=200)
  tmp <- suppressWarnings(psdCalc(~tl,data=df1,species="Yellow perch"))
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),7)
  expect_equal(ncol(tmp),3)
  expect_equal(rownames(tmp),c("PSD-Q","PSD-P","PSD-M","PSD-T","PSD Q-P","PSD P-M","PSD M-T"))
  expect_equal(colnames(tmp),c("Estimate","95% LCI","95% UCI"))
  ## All values, but df only has values greater than memorable value
  df1 <- filterD(df,tl>=300)
  tmp <- suppressWarnings(psdCalc(~tl,data=df1,species="Yellow perch"))
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),5)
  expect_equal(ncol(tmp),3)
  expect_equal(rownames(tmp),c("PSD-Q","PSD-P","PSD-M","PSD-T","PSD M-T"))
  expect_equal(colnames(tmp),c("Estimate","95% LCI","95% UCI"))
})

test_that("psdAdd() results",{
  tmp <- df
  tmp$PSD <- suppressMessages(psdAdd(tl~species,data=tmp))
  expect_equal(ncol(tmp),4)
  expect_true(is.factor(tmp$PSD))
  tmp$PSD <- suppressMessages(psdAdd(tl~species,data=tmp,use.names=FALSE))
  expect_equal(ncol(tmp),4)
  expect_true(is.numeric(tmp$PSD))
})

test_that("Does psdAdd() create correct Gabelhouse categories?",{
  suppressMessages(df2$gcatn <- psdAdd(tl~species,data=df2))
  expect_equivalent(df2$gcatn,df2$GCATN)
})

test_that("Does psdCalc() compute correct PSD values?",{
  suppressWarnings(bgres <- psdCalc(~tl,data=df2bg,species="Bluegill"))
  expect_equivalent(bgres[,"Estimate"],c(80,60,40,20,20,20,20,20))
  suppressWarnings(lmbres <- psdCalc(~tl,data=df2lmb,species="Largemouth Bass"))
  expect_equivalent(lmbres[,"Estimate"],c(60,30,10,40,30,20,10))
})
