context("mrClosed() OUTPUT")

test_that("mrClosed() Single Census output",{
  data(BluegillJL)
  ch1 <- capHistSum(BluegillJL)
  mr1 <- mrClosed(ch1)
  expect_is(mr1,"mrClosed1")
  expect_equal(mode(mr1),"list")
  expect_equal(mr1$method,"Petersen")
  mr2 <- mrClosed(ch1,method="Chapman")
  expect_is(mr2,"mrClosed1")
  expect_equal(mode(mr2),"list")
  expect_equal(mr2$method,"Chapman")
  mr3 <- mrClosed(ch1,method="Ricker")
  expect_is(mr3,"mrClosed1")
  expect_equal(mode(mr3),"list")
  expect_equal(mr3$method,"Ricker")
  mr4 <- mrClosed(ch1,method="Bailey")
  expect_is(mr4,"mrClosed1")
  expect_equal(mode(mr4),"list")
  expect_equal(mr4$method,"Bailey")
  
  tmp <- summary(mr1)
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),1)
  expect_equal(colnames(tmp),"N")
  tmp <- summary(mr1,incl.SE=TRUE)
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),2)
  expect_equal(colnames(tmp),c("N","SE"))
  expect_message(summary(mr1,verbose=TRUE),"Petersen")
  tmp <- summary(mr2)
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),1)
  expect_equal(colnames(tmp),"N")
  tmp <- summary(mr2,incl.SE=TRUE)
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),2)
  expect_equal(colnames(tmp),c("N","SE"))
  expect_message(summary(mr1,verbose=TRUE),"Petersen")
  tmp <- summary(mr3)
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),1)
  expect_equal(colnames(tmp),"N")
  tmp <- summary(mr3,incl.SE=TRUE)
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),2)
  expect_equal(colnames(tmp),c("N","SE"))
  expect_message(summary(mr1,verbose=TRUE),"Petersen")
  tmp <- summary(mr4)
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),1)
  expect_equal(colnames(tmp),"N")
  tmp <- summary(mr4,incl.SE=TRUE)
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),2)
  expect_equal(colnames(tmp),c("N","SE"))
  expect_message(summary(mr1,verbose=TRUE),"Petersen")
  
  expect_message(tmp <- confint(mr1,verbose=TRUE),"Poisson")
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),2)
  expect_equal(colnames(tmp),c("95% LCI","95% UCI"))
  expect_message(tmp <- confint(mr1,verbose=TRUE,type="binomial"),"binomial")
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),2)
  expect_equal(colnames(tmp),c("95% LCI","95% UCI"))
  expect_message(tmp <- confint(mr1,verbose=TRUE,type="hypergeometric"),"hypergeometric")
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),2)
  expect_equal(colnames(tmp),c("95% LCI","95% UCI"))
  expect_message(tmp <- confint(mr2,verbose=TRUE),"Poisson")
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),2)
  expect_equal(colnames(tmp),c("95% LCI","95% UCI"))
  expect_message(tmp <- confint(mr3,verbose=TRUE),"Poisson")
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),2)
  expect_equal(colnames(tmp),c("95% LCI","95% UCI"))
  expect_message(tmp <- confint(mr4,verbose=TRUE),"Poisson")
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),2)
  expect_equal(colnames(tmp),c("95% LCI","95% UCI"))
})
  
test_that("mrClosed() Single Census with subgroups output",{
  marked <- c(93,35,72,16,46,20)
  captured <- c(103,30,73,17,39,18)
  recaps <- c(20,23,52,15,35,16)
  lbls <- c("YOY","Juvenile","Stock","Quality","Preferred","Memorable")
  mr1 <- mrClosed(marked,captured,recaps)
  mr2 <- mrClosed(marked,captured,recaps,labels=lbls)
  expect_is(mr1,"mrClosed1")
  expect_equal(mode(mr1),"list")
  expect_is(mr2,"mrClosed1")
  expect_equal(mode(mr2),"list")
  
  expect_message(tmp <- summary(mr1,verbose=TRUE),"Petersen")
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),length(marked)+1)
  expect_equal(ncol(tmp),1)
  expect_equal(colnames(tmp),"N")
  expect_equal(rownames(tmp),c(LETTERS[1:length(marked)],"All"))
  tmp <- summary(mr1,incl.SE=TRUE)
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),length(marked)+1)
  expect_equal(ncol(tmp),2)
  expect_equal(colnames(tmp),c("N","SE"))
  expect_equal(rownames(tmp),c(LETTERS[1:length(marked)],"All"))
  tmp <- summary(mr1,incl.SE=TRUE,incl.all=FALSE)
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),length(marked))
  expect_equal(ncol(tmp),2)
  expect_equal(colnames(tmp),c("N","SE"))
  expect_equal(rownames(tmp),LETTERS[1:length(marked)])
  tmp <- summary(mr2,incl.SE=TRUE,incl.all=FALSE)
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),length(marked))
  expect_equal(ncol(tmp),2)
  expect_equal(colnames(tmp),c("N","SE"))
  expect_equal(rownames(tmp),lbls)
  
  expect_message(tmp <- confint(mr1,verbose=TRUE,type="binomial"),"binomial")
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),length(marked)+1)
  expect_equal(ncol(tmp),2)
  expect_equal(colnames(tmp),c("95% LCI","95% UCI"))
  expect_equal(rownames(tmp),c(LETTERS[1:length(marked)],"All"))
  tmp <- confint(mr1,incl.all=FALSE)
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),length(marked))
  expect_equal(ncol(tmp),2)
  expect_equal(colnames(tmp),c("95% LCI","95% UCI"))
  expect_equal(rownames(tmp),LETTERS[1:length(marked)])
  tmp <- confint(mr2,incl.all=FALSE)
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),length(marked))
  expect_equal(ncol(tmp),2)
  expect_equal(colnames(tmp),c("95% LCI","95% UCI"))
  expect_equal(rownames(tmp),lbls)
})
  
test_that("mrClosed() Schnabel output",{
  data(PikeNY)
  mr1 <- with(PikeNY,mrClosed(n=n,m=m,R=R,method="Schnabel"))
  mr2 <- with(PikeNY,mrClosed(n=n,m=m,R=R,method="Schnabel",chapman.mod=FALSE))
  
  expect_is(mr1,"mrClosed2")
  expect_equal(mode(mr1),"list")
  expect_equal(mr1$method,"Schnabel")
  expect_true(mr1$chapman.mod)
  expect_is(mr2,"mrClosed2")
  expect_equal(mode(mr2),"list")
  expect_equal(mr2$method,"Schnabel")
  expect_false(mr2$chapman.mod)
  
  expect_message(tmp <- summary(mr1,verbose=TRUE),"Schnabel")
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),1)
  expect_equal(colnames(tmp),"N")

  expect_message(tmp <- confint(mr1,verbose=TRUE),"normal")
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),2)
  expect_equal(colnames(tmp),c("95% LCI","95% UCI"))
  expect_message(tmp <- confint(mr1,verbose=TRUE,type="Poisson"),"Poisson")
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),2)
  expect_equal(colnames(tmp),c("95% LCI","95% UCI"))
  expect_message(tmp <- confint(mr1,verbose=TRUE,type="normal"),"normal")
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),2)
  expect_equal(colnames(tmp),c("95% LCI","95% UCI"))
})

test_that("mrClosed() Schnabel with capHistSum() output",{
  data(PikeNYPartial1)
  ch <- capHistSum(PikeNYPartial1,cols2ignore="id")
  
  mr1 <- mrClosed(ch,method="Schnabel")
  mr2 <- mrClosed(ch,method="Schnabel",chapman.mod=FALSE)
  
  expect_is(mr1,"mrClosed2")
  expect_equal(mode(mr1),"list")
  expect_equal(mr1$method,"Schnabel")
  expect_true(mr1$chapman.mod)
  expect_is(mr2,"mrClosed2")
  expect_equal(mode(mr2),"list")
  expect_equal(mr2$method,"Schnabel")
  expect_false(mr2$chapman.mod)
  
  expect_message(tmp <- summary(mr1,verbose=TRUE),"Schnabel")
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),1)
  expect_equal(colnames(tmp),"N")
  
  expect_message(tmp <- confint(mr1,verbose=TRUE,type="Poisson"),"Poisson")
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),2)
  expect_equal(colnames(tmp),c("95% LCI","95% UCI"))
  expect_message(tmp <- confint(mr1,verbose=TRUE,type="normal"),"normal")
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),2)
  expect_equal(colnames(tmp),c("95% LCI","95% UCI"))
})

test_that("mrClosed() Schumacher-Eschmeyer output",{
  data(PikeNY)
  mr1 <- with(PikeNY,mrClosed(n=n,m=m,R=R,method="Schumacher"))
  
  expect_is(mr1,"mrClosed2")
  expect_equal(mode(mr1),"list")
  
  expect_message(tmp <- summary(mr1,verbose=TRUE),"Schumacher")
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),1)
  expect_equal(colnames(tmp),"N")
  
  expect_message(tmp <- confint(mr1,verbose=TRUE),"normal")
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),2)
  expect_equal(colnames(tmp),c("95% LCI","95% UCI"))
})

test_that("mrClosed() Schumacher-Eschmeyer capHistSum() output",{
  data(PikeNYPartial1)
  ch <- capHistSum(PikeNYPartial1,cols2ignore="id")
  mr1 <- mrClosed(ch,method="Schumacher")
  
  expect_is(mr1,"mrClosed2")
  expect_equal(mode(mr1),"list")
  
  expect_message(tmp <- summary(mr1,verbose=TRUE),"Schumacher")
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),1)
  expect_equal(colnames(tmp),"N")
  
  expect_message(tmp <- confint(mr1,verbose=TRUE),"normal")
  expect_is(tmp,"matrix")
  expect_equal(mode(tmp),"numeric")
  expect_equal(nrow(tmp),1)
  expect_equal(ncol(tmp),2)
  expect_equal(colnames(tmp),c("95% LCI","95% UCI"))
})
