% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparisonsDVR.R
\name{compSlopes}
\alias{compSlopes}
\alias{print.compSlopes}
\title{Tests for significant differences among all pairs of slopes in a dummy variable regression (DVR).}
\usage{
compSlopes(mdl, method = stats::p.adjust.methods, conf.level = 0.95,
  order.slopes = TRUE, digits = getOption("digits"))

\method{print}{compSlopes}(x, ...)
}
\arguments{
\item{mdl}{A \code{lm} object.}

\item{method}{A string indicating the method of p-value adjustment to use.  See details and \code{\link[stats]{p.adjust.methods}}.}

\item{conf.level}{A single number that represents the level of confidence to use for constructing confidence intervals.}

\item{order.slopes}{A logical indicating whether the slopes should be ordered from smallest to largest upon output.}

\item{digits}{A numeric that controls the number of digits to print.}

\item{x}{A \code{compSlopes} object (i.e., returned from \code{compSlopes}).}

\item{\dots}{Other arguments sent to \code{print}.}
}
\value{
A list with three components.  The first component contains the p-value adjustment method in \code{method}.  The second component, called \code{comparisons}, is a data.frame that contains the following:
\tabular{ll}{
\code{comparison} \tab Description of how the difference in levels was computed.\cr
\code{diff} \tab The estimated difference in slope values.\cr
\code{lwr} \tab Lower confidence bound for difference in slope values.\cr 
\code{upr} \tab Upper confidence bound for difference in slope values.\cr 
\code{p.unadj} \tab Unadjusted p-value for testing the difference in slopes is zero.\cr 
\code{p.adj} \tab Adjusted p-value for testing the difference in slopes is zero.\cr
}

The third component, called \code{slopes}, is a data.frame that contains the following:
\tabular{ll}{
\code{level} \tab A level name.\cr
\code{slope} \tab The estimated slope value for the given level.\cr
\code{XX LCI} \tab Lower confidence bound for difference in slope values.\cr
\code{XX UCI} \tab Upper confidence bound for difference in slope values.\cr
\code{p.unadj} \tab Unadjusted p-value for testing the slope is zero.\cr 
\code{p.adj} \tab Adjusted p-value for testing the slope is zero.\cr
}

The \code{print} function prints the results nicely.
}
\description{
Tests for significant differences among all pairs of slopes in a dummy variable regression where the dummy variables all stem from one factor.
}
\details{
In a dummy variable regression the coefficient for the interaction between the covariate (x) and a dummy variable tests for a difference in slopes between the level of the dummy variable and the reference level.  Thus, all dummy variables from a particular linear model fit only compare slopes with the reference level.  Other slope comparisons may be found by changing the reference level, which requires refitting the model.  This function automates this sequential process and produces a data.frame that shows the estimated difference, an unadjusted confidence interval for the difference, and the unadjusted and adjusted (for multiplce comparisons) p-values for testing that the difference in slopes is equal to zero for each pair of levels.  The adjusted p-values may be computed with any of the methods coded in \code{\link[stats]{p.adjust}} (see \code{\link[stats]{p.adjust.methods}}).
}
\note{
This function only works for linear models with one factor variable.
}
\examples{
data(Mirex)
Mirex$year <- factor(Mirex$year)
# fit a dummy variable regression, see that slopes differ
lm1 <- lm(mirex~weight*year,data=Mirex)
anova(lm1)
# compare all pairs of slopes using default Holm control
compSlopes(lm1)
# compare all pairs of slopes using the false discovery rate control
compSlopes(lm1,method="fdr")
# visualize the results
fitPlot(lm1)

}
\author{
Derek H. Ogle, \email{derek@derekogle.com}
}
\seealso{
\code{\link{compIntercepts}} in \pkg{FSA}.
}
\keyword{htest}

