% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localSearch.R
\name{hc}
\alias{hc}
\title{Hill-Climbing}
\usage{
hc(data, class, featureSetEval, start = NULL, nneigh = length(data) -
  1, repeats = 1, verbose = FALSE)
}
\arguments{
\item{data}{\itemize{
\item A data frame with the features and the class of the examples
}}

\item{class}{\itemize{
\item The name of the dependent variable
}}

\item{featureSetEval}{\itemize{
\item The measure for evaluate features
}}

\item{start}{\itemize{
\item Binary vector with the set of initial features
}}

\item{nneigh}{\itemize{
\item Number of neighbors to evaluate in each iteration of the algorithm
}}

\item{repeats}{\itemize{
\item Number of repetitions of the algorithm
}}

\item{verbose}{\itemize{
\item Print the partial results in each iteration
}}
}
\value{
A list is returned containing for each repetition of the algorithm:
\describe{
\item{bestFeatures}{A vector with all features. Selected features are marked with 1, unselected features are marked with 0}
\item{bestFitness}{Evaluation measure obtained with the feature selection}
\item{initialVector}{The vector with which the algorithm started}
\item{initialFitness}{The evaluation measure of the initial vector}
\item{trace}{Matrix with the results of each iteration. It contains the number of the iteration, the best set of features selected by the algorithm up to that iteration (1: selected, 0: not selected) and the value of the evaluation measure obtained from that best set of features}
}
}
\description{
The hc \insertCite{Russell2009}{FSinR} method starts with a certain set of features and in each iteration it searches among its neighbors to advance towards a better solution. The method ends as soon as no better solutions are found
}
\examples{
## Hill-Climbing method for iris dataset (filter method)
hc(iris, 'Species', roughsetConsistency)
}
\references{
\insertAllCited{}
}
\author{
Francisco Aragón Royón
}
