context("Select Individual Features")

test_that("Percentile function works", {
  result <- selectPercentile(iris,'Species',IEConsistency,40)
  expect_equal(result$featuresSelected, c("Petal.Width","Petal.Length"))
  expect_equal(result$valuePerFeature, c(0.9600000, 0.9533333), tolerance = 1e-4)
  expect_true(all(result$bestFeatures == c(Sepal.Length = 0, Sepal.width = 0, Petal.Length = 1, Petal.Width = 1)))
  expect_equal(dimnames(result$bestFeatures)[[2]], dimnames(data.frame(Sepal.Length = 0, Sepal.Width = 0, Petal.Length = 1, Petal.Width = 1))[[2]])
  result <- selectPercentile(iris,'Species',IEConsistency)
  expect_equal(result$featuresSelected, "Petal.Width")
  expect_equal(result$valuePerFeature, 0.96)
  expect_true(all(result$bestFeatures == c(Sepal.Length = 0, Sepal.width = 0, Petal.Length = 0, Petal.Width = 1)))
  expect_equal(dimnames(result$bestFeatures)[[2]], dimnames(data.frame(Sepal.Length = 0, Sepal.Width = 0, Petal.Length = 0, Petal.Width = 1))[[2]])
})

test_that("Threshold function works", {
  result <- selectThreshold(iris,'Species',IEConsistency,0.9)
  expect_equal(result$featuresSelected, c("Petal.Width","Petal.Length"))
  expect_equal(result$valuePerFeature, c(0.9600000, 0.9533333), tolerance = 1e-4)
  expect_true(all(result$bestFeatures == c(Sepal.Length = 0, Sepal.width = 0, Petal.Length = 1, Petal.Width = 1)))
  expect_equal(dimnames(result$bestFeatures)[[2]], dimnames(data.frame(Sepal.Length = 0, Sepal.Width = 0, Petal.Length = 1, Petal.Width = 1))[[2]])
  result <- selectThreshold(iris,'Species',IEConsistency)
  expect_equal(result$featuresSelected, c("Petal.Width","Petal.Length", "Sepal.Length", "Sepal.Width"))
  expect_equal(result$valuePerFeature, c(0.9600000, 0.9533333, 0.7666667, 0.6066667), tolerance = 1e-4)
  expect_true(all(result$bestFeatures == c(Sepal.Length = 1, Sepal.width = 1, Petal.Length = 1, Petal.Width = 1)))
  expect_equal(dimnames(result$bestFeatures)[[2]], dimnames(data.frame(Sepal.Length = 1, Sepal.Width = 1, Petal.Length = 1, Petal.Width = 1))[[2]])
})

test_that("Threshold range function works", {
  result <- selectThresholdRange(iris,'Species',IEConsistency,0.9)
  expect_equal(result$featuresSelected, c("Petal.Width","Petal.Length"))
  expect_equal(result$valuePerFeature, c(0.9600000, 0.9533333), tolerance = 1e-4)
  expect_true(all(result$bestFeatures == c(Sepal.Length = 0, Sepal.width = 0, Petal.Length = 1, Petal.Width = 1)))
  expect_equal(dimnames(result$bestFeatures)[[2]], dimnames(data.frame(Sepal.Length = 0, Sepal.Width = 0, Petal.Length = 1, Petal.Width = 1))[[2]])
  result <- selectThresholdRange(iris,'Species',IEConsistency)
  expect_equal(result$featuresSelected, c("Petal.Width","Petal.Length", "Sepal.Length"))
  expect_equal(result$valuePerFeature, c(0.9600000, 0.9533333, 0.7666667), tolerance = 1e-4)
  expect_true(all(result$bestFeatures == c(Sepal.Length = 1, Sepal.width = 0, Petal.Length = 1, Petal.Width = 1)))
  expect_equal(dimnames(result$bestFeatures)[[2]], dimnames(data.frame(Sepal.Length = 1, Sepal.Width = 0, Petal.Length = 1, Petal.Width = 1))[[2]])
})

test_that("Difference function works", {
  result <- selectDifference(iris,'Species',IEConsistency)
  expect_equal(result$featuresSelected, c("Petal.Width","Petal.Length"))
  expect_equal(result$valuePerFeature, c(0.9600000, 0.9533333), tolerance = 1e-4)
  expect_true(all(result$bestFeatures == c(Sepal.Length = 0, Sepal.width = 0, Petal.Length = 1, Petal.Width = 1)))
  expect_equal(dimnames(result$bestFeatures)[[2]], dimnames(data.frame(Sepal.Length = 0, Sepal.Width = 0, Petal.Length = 1, Petal.Width = 1))[[2]])
  result <- selectDifference(iris,'Species',IEConsistency,0.9)
  expect_equal(result$featuresSelected, c("Petal.Width","Petal.Length", "Sepal.Length", "Sepal.Width"))
  expect_equal(result$valuePerFeature, c(0.9600000, 0.9533333, 0.7666667, 0.6066667), tolerance = 1e-4)
  expect_true(all(result$bestFeatures == c(Sepal.Length = 1, Sepal.width = 1, Petal.Length = 1, Petal.Width = 1)))
  expect_equal(dimnames(result$bestFeatures)[[2]], dimnames(data.frame(Sepal.Length = 1, Sepal.Width = 1, Petal.Length = 1, Petal.Width = 1))[[2]])
})

test_that("Slope function works", {
  result <- selectSlope(iris,'Species',IEConsistency,0.4)
  expect_equal(result$featuresSelected, c("Petal.Width","Petal.Length"))
  expect_equal(result$valuePerFeature, c(0.9600000, 0.9533333), tolerance = 1e-4)
  expect_true(all(result$bestFeatures == c(Sepal.Length = 0, Sepal.width = 0, Petal.Length = 1, Petal.Width = 1)))
  expect_equal(dimnames(result$bestFeatures)[[2]], dimnames(data.frame(Sepal.Length = 0, Sepal.Width = 0, Petal.Length = 1, Petal.Width = 1))[[2]])
  result <- selectSlope(iris,'Species',IEConsistency)
  expect_equal(result$featuresSelected, c("Petal.Width","Petal.Length", "Sepal.Length", "Sepal.Width"))
  expect_equal(result$valuePerFeature, c(0.9600000, 0.9533333, 0.7666667, 0.6066667), tolerance = 1e-4)
  expect_true(all(result$bestFeatures == c(Sepal.Length = 1, Sepal.width = 1, Petal.Length = 1, Petal.Width = 1)))
  expect_equal(dimnames(result$bestFeatures)[[2]], dimnames(data.frame(Sepal.Length = 1, Sepal.Width = 1, Petal.Length = 1, Petal.Width = 1))[[2]])
})