% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdlc.R
\name{MDLC}
\alias{MDLC}
\title{MDLC evaluation measure}
\usage{
MDLC()
}
\value{
Returns a function that is used to generate an evaluation set measure using MDLC value for the selected features
}
\description{
Generates an evaluation function that applies the Minimum-Description_Length-Criterion (MDLC) \insertCite{Sheinvald1990}{FSinR} to generate an evaluation measure for a set of features (set measure). This function is called internally within the \code{\link{filterEvaluator}} function.
}
\examples{
\dontrun{ 

## The direct application of this function is an advanced use that consists of using this 
# function directly to evaluate a set of features
## Classification problem

# A discrete dataset is used (in this case we use only several discrete columns)
adult <- adult[,c(4,9,10,15)]

# Generate the evaluation function with MDLC
MDLC_evaluator <- MDLC()
# Evaluate the features (parameters: dataset, target variable and features)
MDLC_evaluator(adult,'income',c('race','sex','education'))
}
}
\references{
\insertAllCited{}
}
\author{
Alfonso Jiménez-Vílchez
}
