% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectIndividualFeatures.R
\name{selectPercentile}
\alias{selectPercentile}
\title{Select Percentile}
\usage{
selectPercentile(percentile = 80)
}
\arguments{
\item{percentile}{Number (positive integer) between 0 and 100}
}
\value{
Returns a direct search function that is used in the feature selection process.
}
\description{
Generates a direct search function that selects a fraction, given as a percentage, of the total number of available features (The features evaluation is individual). This function is called internally within the \code{\link{directSearchAlgorithm}} function.
}
\examples{
\dontrun{ 

## The direct application of this function is an advanced use that consists of using this 
# function directly and performing a direct search process
## Classification problem


# Generates the filter evaluation function
filter_evaluator <- filterEvaluator('determinationCoefficient')

# Generates the direct search function with percentile
sp_direct_search <- selectPercentile()
# Performs the direct search process directly (parameters: dataset, target variable and evaluator)
sp_direct_search(iris, 'Species', filter_evaluator)
}
}
\author{
Adan M. Rodriguez

Francisco Aragón Royón
}
