% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapperGenerator.R
\name{wrapperEvaluator}
\alias{wrapperEvaluator}
\title{Wrapper measure generator}
\usage{
wrapperEvaluator(learner, resamplingParams = list(), fittingParams = list())
}
\arguments{
\item{learner}{Learner to be used. The models available are the models available in caret: http://topepo.github.io/caret/available-models.html}

\item{resamplingParams}{Control parameters for evaluating the impact of model tuning parameters. The arguments are the same as those of the caret trainControl function. By default an empty list. In this case the default caret values are used for resampling and fitting.}

\item{fittingParams}{Control parameters for choose the best model across the parameters. The arguments are the same as those of the caret train function (minus the parameters: x, y, form, data, method and trainControl). By default an empty list. In this case the default caret values are used for resampling and fitting.}
}
\value{
Returns a wrapper function that is used to generate an evaluation measure
}
\description{
Generates a wrapper function to be used as an evaluator \insertCite{kohavi1997}{FSinR} in the feature selection proccess, given a learner algorithm and related customizable parameters \insertCite{caret}{FSinR}. More specifically, the result of calling this function is another function that is passed on as a parameter to the \code{\link{featureSelection}} function. However, you can also run this function directly to generate an evaluation measure.
}
\details{
generaWrapper
}
\examples{
\dontrun{ 

## Examples of a wrapper evaluator generation

wrapper_evaluator_1 <- wrapperEvaluator('knn')
wrapper_evaluator_2 <- wrapperEvaluator('mlp')
wrapper_evaluator_3 <- wrapperEvaluator('randomForest')


## Examples of a wrapper evaluator generation (with parameters)

# Values for the caret trainControl function (resampling parameters)
resamplingParams <- list(method = "repeatedcv", repeats = 3)
# Values for the caret train function (fitting parameters)
fittingParams <- list(preProc = c("center", "scale"), metric="Accuracy",
                      tuneGrid = expand.grid(k = c(1:12)))
                      
wrapper_evaluator <- wrapperEvaluator('knn', resamplingParams, fittingParams)


## The direct application of this function is an advanced use that consists of using this 
# function directly to evaluate a set of features
## Classification problem

# Generates the wrapper evaluation function
wrapper_evaluator <- wrapperEvaluator('knn')
# Evaluates features directly (parameters: dataset, target variable and features)
wrapper_evaluator(iris,'Species',c('Sepal.Length','Sepal.Width','Petal.Length','Petal.Width'))
}
}
\references{
\insertAllCited{}
}
\author{
Alfonso Jiménez-Vílchez

Francisco Aragón Royón
}
