% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaheuristic.R
\name{antColony}
\alias{antColony}
\title{Ant Colony Optimization (Advanced Binary Ant Colony Optimization)}
\usage{
antColony(
  population = 10,
  iter = 10,
  a = 1,
  b = 1,
  p = 0.2,
  q = 1,
  t0 = 0.2,
  tmin = 0,
  tmax = 1,
  mode = 1,
  verbose = FALSE
)
}
\arguments{
\item{population}{The number of ants population}

\item{iter}{The number of iterations}

\item{a}{Parameter to control the influence of the pheromone (If a=0, no pheromone information is used)}

\item{b}{Parameter to control the influence of the heuristic (If b=0, the attractiveness of the movements is not taken into account)}

\item{p}{Rate of pheromone evaporation}

\item{q}{Constant to determine the amount of pheromone deposited by the best ant. This amount is determined by the Q/F equation (for minimization) where F is the cost of the solution (F/Q for maximization)}

\item{t0}{Initial pheromone level}

\item{tmin}{Minimum pheromone value}

\item{tmax}{Maximum pheromone value}

\item{mode}{Heuristic information measurement. 1 -> min redundancy (by default). 2-> max-relevance and min-redundancy. 3-> feature-feature. 4-> based on F-score}

\item{verbose}{Print the partial results in each iteration}
}
\value{
Returns a search function that is used to guide the feature selection process.
}
\description{
Generates a search function based on the ant colony optimization. This function is called internally within the \code{\link{searchAlgorithm}} function. The Ant Colony Optimization (Advanced Binary Ant Colony Optimization) \insertCite{Kashef2015}{FSinR} algorithm consists of generating in each iteration a random population of individuals (ants) according to the values of a pheromone matrix (which is updated each iteration according to the paths most followed by the ants) and a heuristic (which determines how good is each path to follow by the ants). The evaluation measure is calculated for each individual. The algorithm ends once the established number of iterations has been reached
}
\examples{
\dontrun{ 

## The direct application of this function is an advanced use that consists of using this 
# function directly and performing a search process in a feature space
## Classification problem

# Generates the filter evaluation function with ACO
filter_evaluator <- filterEvaluator('determinationCoefficient')

# Generates the search function
aco_search <- antColony()
# Performs the search process directly (parameters: dataset, target variable and evaluator)
aco_search(iris, 'Species', filter_evaluator)
}
}
\references{
\insertAllCited{}
}
\author{
Francisco Aragón Royón
}
