% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_funcs.R
\name{print.farm.select}
\alias{print.farm.select}
\title{Summarize and print the results of the model selection}
\usage{
\method{print}{farm.select}(x, ...)
}
\arguments{
\item{x}{A \code{farm.select} object.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
A list with the following items:
\item{model.size}{the size of the model}
\item{beta.chosen}{the indices of the covariates chosen in the model}
\item{coef.chosen}{the coefficients of the chosen covariates}
\item{X.residual}{the residual covariate matrix after adjusting for factors}
\item{nfactors}{number of (estimated) factors}
\item{n}{number of observations}
\item{p}{number of dimensions}
\item{robust}{whether robust parameters were used}
\item{loss}{loss function used}
}
\description{
Print method for \code{farm.select} objects
}
\examples{
set.seed(100)
P = 200 #dimension
N = 50 #samples
K = 3 #nfactors
Q = 3 #model size
Lambda = matrix(rnorm(P*K, 0,1), P,K)
F = matrix(rnorm(N*K, 0,1), N,K)
U = matrix(rnorm(P*N, 0,1), P,N)
X = Lambda\%*\%t(F)+U
X = t(X)
beta_1 = rep(5,Q)
beta = c(beta_1, rep(0,P-Q))
eps = rt(N, 2.5)
Y = X\%*\%beta+eps

##with default options
output = farm.select(X,Y)
output
}
\seealso{
\code{\link{farm.select}}
}
