#' FarmTest: Factor Adjusted Robust Multiple Testing
#'
#' This R package conducts multiple hypothesis testing of mean effects. It implements a robust procedure to estimate distribution parameters and accounts for strong dependence among coordinates via an approximate factor model. This method is particularly suitable for high-dimensional data when there are thousands of variables but only a small number of observations available. Moreover, the method is tailored to cases when the underlying distribution deviates from Gaussianity, which is commonly assumed in the literature.
#' For detailed information on how to use and install see \url{https://kbose28.github.io/FarmTest/}. See the paper on the 'FarmTest' method, Zhou et al.(2017) at \url{https://goo.gl/68SJpd}, for detailed description of methods and further references.
#'
#'
#'@references Zhou, W-X., Fan, J., Ke, Y. and Sun, Q. (2012). "FARM-Test: Factor-adjusted robust multiple testing with false discovery control," Preprint.
#' @name FarmTest
#' @docType package
NULL
