% Generated by roxygen2 (4.0.1): do not edit by hand
\name{elevenprobs}
\alias{elevenprobs}
\alias{fiveprobs}
\alias{sevenprobs}
\title{Five, Seven, Eleven Probabilities}
\usage{
elevenprobs(X, parnames = FALSE)

sevenprobs(X, parnames = FALSE)

fiveprobs(X, parnames = FALSE)
}
\arguments{
\item{X}{numeric. Vector of quantiles.}

\item{parnames}{boolean. Parameter vector with or without names.}
}
\value{
A vector of 11 probabilities
\code{c(1-p1, 1-p2, 1-p3, 0.25, 0.35, 0.50, 0.65, 0.75, p3, p2, p1)}.

A vector of 7 probabilities
\code{c(1-p1, 1-p2, 0.25, 0.50, 0.75, p2, p1)}.

A vector of 5 probabilities
\code{c(1-p1, 0.25, 0.50, 0.75, p1)}.
}
\description{
Extract from a dataset \code{X} a vector of 5, 7 or 11 probabilities
\code{c(1-p1, 0.25, 0.50, 0.75, p1)},
\code{c(1-p1, 1-p2, 0.25, 0.50, 0.75, p2, p1)},
\code{c(1-p1, 1-p2, 1-p3, 0.25, 0.35, 0.50, 0.65, 0.75, p3, p2, p1)}.
p1, p2 and p3 are the most extreme probabilities of the dataset \code{X}
with values finishing either by \code{pp950} or \code{pp975} or \code{pp990}.

Parameters names take the parameter values if \code{parnames = TRUE}.




}
\examples{
## DS
DS   <- getDSdata()
for (j in 1:16) { print(round(elevenprobs(DS[[j]]), 6)) }

## Choose j in 1:16
j    <- 1
X    <- sort(DS[[j]])
leX  <- logit(eX <- elevenprobs(X))
lpX  <- logit(ppoints(length(X), a = 0))
plot(X, lpX)
abline(h = leX, lty = 3)
mtext(eX, side = 4, at = leX, las = 1, line = -3.3)
## end
}
\seealso{
\code{\link{estimkienerX}}.
}

