% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FateID_functions.R
\name{plotexpression}
\alias{plotexpression}
\title{Plotting of pseudo-temporal expression profiles}
\usage{
plotexpression(x, y, g, n, col = NULL, name = NULL, cluster = FALSE,
  alpha = 0.5, types = NULL, cex = 3, ylim = NULL, map = TRUE,
  leg = TRUE)
}
\arguments{
\item{x}{expression data frame with genes as rows and cells as columns. Gene IDs should be given as row names and cell IDs should be given as column names.}

\item{y}{clustering partition. A vector with an integer cluster number for each cell. The order of the cells has to be the same as for the columns of \code{x}.}

\item{g}{a gene ID corresponding to one of the rownames of \code{x}. In the latter case, the input argument \code{x} needs to be provided. A vector of gene IDs can also be provided. In this case, the aggregated expression across all gene IDs is plotted.}

\item{n}{ordered vector of cell IDs to be included. Cell IDs need to be column names of \code{x}.}

\item{col}{optional vector of valid color names for all clusters in \code{y} ordered by increasing cluster number. Default value is \code{NULL}.}

\item{name}{optional character string. This argument corresponds to a title for the plot. Default value is \code{NULL}. If not provided, and \code{g} is given, then \code{name} will equal \code{g} or \code{g[1]}, respectively, if \code{g} is a vector of gene IDs.}

\item{cluster}{logical value. If \code{TRUE} then the partitioning along the x-axis is indicated be vertical lines representing the boundaries of all positions with a given value in \code{y}. The average position across all cells in a cluster will be indicated on the x-axis.}

\item{alpha}{positive real number. Pseudo-temporal expression profiles are derived by a local regression of expression values across the ordered cells using the function \code{loess} from the package \pkg{stats}. This is the parameter, which controls the degree of smoothing. Larger values return smoother profiles. Default value is 0.5.}

\item{types}{optional vector with IDs for different subsets of cells in \code{y}, e. g. different batches. All cells with the same ID will be displayed by the same symbol and color. Default value is \code{NULL}}

\item{cex}{size of data points. Default value is 3.}

\item{ylim}{vector of two numerical values: lower and upper limit of values shown on the y-axis. Default value is \code{NULL} and the whole range is shown.}

\item{map}{logical. If \code{TRUE} then data points are shown. Default value is \code{TRUE}.}

\item{leg}{logical. If \code{TRUE} then axes and labels are shown. Default value is \code{TRUE}.}
}
\value{
None
}
\description{
This function allows plotting pseudo-temporal expression profiles for single genes or groups of genes.
}
\examples{

\donttest{
x <- intestine$x
y <- intestine$y
v <- intestine$v
fcol <- intestine$col
tar <- c(6,9,13)
fb <- fateBias(x,y,tar,z=NULL,minnr=5,minnrh=10,nbfactor=5,use.dist=FALSE,seed=NULL,nbtree=NULL)
dr <- compdr(x,z=NULL,m="cmd",k=2,lle.n=30,dm.sigma=1000,dm.distance="euclidean",tsne.perplexity=30)
pr <- prcurve(y,fb,dr,k=2,m="cmd",trthr=0.4,start=NULL)
n <- pr$trc[["t6"]]
fs  <- filterset(v,n,minexpr=2,minnumber=1)
s1d <- getsom(fs,nb=1000,alpha=.5)
ps <- procsom(s1d,corthr=.85,minsom=3)
# plot average profile of all genes of node 1 in the self-organizing map
g <- names(ps$nodes)[ps$nodes == 1]
plotexpression(v,y,g,n,col=fcol,name="Node 1",cluster=FALSE,alpha=.5,types=NULL)
}

}
