% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FateID_functions.R
\name{gene2gene}
\alias{gene2gene}
\title{Comparative plot of the expression levels of two genes}
\usage{
gene2gene(
  x,
  y,
  g1,
  g2,
  clusters = NULL,
  fb = NULL,
  tn = NULL,
  col = NULL,
  tp = 1,
  plotnum = TRUE,
  seed = 12345
)
}
\arguments{
\item{x}{expression data frame with genes as rows and cells as columns. Gene IDs should be given as row names and cell IDs should be given as column names. This can be a reduced expression table only including the features (genes) to be used in the analysis.}

\item{y}{clustering partition. A vector with an integer cluster number for each cell. The order of the cells has to be the same as for the columns of x.}

\item{g1}{gene id corresponding to a valid row names of x. Expression of gene \code{g1} versus gene \code{g2} will be plotted.}

\item{g2}{gene id corresponding to a valid row names of x. Expression of gene \code{g1} versus gene \code{g2} will be plotted.}

\item{clusters}{vector of valid cluster ids. Expression is displayed for cells in any of the clusters contained in \code{clusters}. If the argument is not given, cells of all clusters are displayed. Default value is \code{NULL}.}

\item{fb}{fateBias object returned by the function \code{fateBias}. Default value is \code{NULL}. Only if both \code{tn} and \code{fb} are provided as input, the fate bias will be colour coded.}

\item{tn}{name of a target cluster, i. e. concatenation of a \code{t} and the number of a target cluster. Has to correspond to a column name of \code{fb$probs}. The default value is \code{NULL}. Only if both \code{tn} and \code{fb} are provided as input, the fate bias will be colour coded.}

\item{col}{optional vector of valid color names for all clusters in \code{y} ordered by increasing cluster number. Default value is \code{NULL}.}

\item{tp}{Transparency of points in the plot. Default value is 1, i. e. non-transparent.}

\item{plotnum}{logical value. If \code{TRUE}, then cluster numbers are displayed on top of the data points. Default value is \code{TRUE}.}

\item{seed}{integer number. Random seed for determining colour scheme. Default is 12345.}
}
\value{
None
}
\description{
This function produces a scatter plot of the expression levels of two genes. It allows plotting cells of selected clusters and permits highlighting of the fate bias.
}
\examples{
x <- intestine$x
y <- intestine$y
v <- intestine$v

tar <- c(6,9,13)
fb <- fateBias(x,y,tar,z=NULL,minnr=5,minnrh=10,nbfactor=5,use.dist=FALSE,seed=NULL,nbtree=NULL)
gene2gene(v,y,"Muc2__chr7","Apoa1__chr9")
gene2gene(v,y,"Muc2__chr7","Apoa1__chr9",fb=fb,tn="t6",plotnum=FALSE)

}
