% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/NED_FUNCTIONS.R
\name{downloadNEDTile}
\alias{downloadNEDTile}
\title{Download a zipped tile from the 1 (~30 meter) or 1/3 (~10 meter) arc-second National Elevation Dataset.}
\usage{
downloadNEDTile(res = NULL, tileNorthing, tileWesting, raw.dir)
}
\arguments{
\item{res}{A character string representing the desired resolution of the NED. "1"
indicates the 1 arc-second NED, while "13" indicates the 1/3 arc-second dataset. Defaults to NULL.}

\item{tileNorthing}{An integer representing the northing (latitude, in degrees north of the equator) of the northwest corner of the tile to
be downloaded.}

\item{tileWesting}{An integer representing the westing (longitude, in degrees west of the prime meridian) of the northwest corner of the tile to
be downloaded.}

\item{raw.dir}{A character string indicating where raw downloaded files should be put.
The directory will be created if missing. Defaults to "./RAW/NED/".}
}
\value{
A character string representing the full local path of the downloaded directory.
}
\description{
Tiles are specified by a resolution, northing, and westing; northing and westing refer to the
northwest corner of each NED tile, in degrees; tiles are 1x1 degree.
Tiles are downloaded in zipped ESRI ArcGrid format. \code{downloadNED} returns the path to the downloaded zip file.
}

