% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01.firm_query.R
\name{query.firm}
\alias{query.firm}
\title{Function to extract information from a \code{firm} object (legal person)}
\usage{
query.firm(firm, which, naming = TRUE)
}
\arguments{
\item{firm}{Firm which to extract information from}

\item{which}{Information to extract, minimum unambiguous substring. Possible values (one or more):
- \code{name} Name of the firm
- \code{id} ID of the firm, usually the ticker (if provided or otherwise known)
- \code{legal_form} Legal form of the firm
- \code{sector} Sector in which the firm operates
- \code{revenues} Yearly revenues
- \code{capitalisation} Capitalisation
- \code{management} Members of the board
- \code{ownership} Owner(s)
- \code{shares} Share owned by (each of) the owner(s)
- \code{currency} Currency in which revenues and capitalisation are denominated}

\item{naming}{Whether to name the result after the querie information (defaults to \code{TRUE})}
}
\value{
Depends on the information queried. One (or, if \code{length(which)>=2}, a \code{\link{list}} of two or more) of the following:
\item{name}{A string representing the name of the firm}
\item{id}{A string representing the ID of the firm (usually its ticker)}
\item{legal_form}{A string representing the firm's legal form}
\item{sector}{A string indicating the sector in which the firm operates (possibly a NACE rev. 2 code)}
\item{revenues}{A numeric (double) quantifying yearly revenues}
\item{capitalisation}{A numeric (double) quantifying capitalisation}
\item{management}{A vector of strings representing the members of the board}
\item{ownership}{A vector of strings representing the owner(s)}
\item{shares}{A numeric (double) vector indicating the shares controlled by (each of) the owner(s)}
\item{currency}{A string indicating the currency in which revenues and capitalisation are denominated}
}
\description{
Function to extract information from a \code{firm} object (legal person)
}
\examples{
\donttest{
# Query Apple's capitalisation
data('firms_US')
list2env(firms_US, parent.frame())
query.firm(AAPL, which = 'capitalisation')

# Query British-American Tobacco's capitalisation using the common abbreviation 'cap'
data('firms_US')
list2env(firms_US, parent.frame())
query.firm(BTI, 'cap')

# Query General Motors's owners and their shares, but return an unnamed \code{\link{list}}
data('firms_US')
list2env(firms_US, parent.frame())
query.firm(GM, c('own', 'sha'), naming = FALSE)
}

}
\seealso{
\link{query.firms} \link{query.firms.dataframe}
}
\author{
\enc{Telarico, Fabio Ashtar}{Fabio Ashtar Telarico}
}
