% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01.firm_register.R
\name{register.firm}
\alias{register.firm}
\title{Function to create a \code{firm} (legal person)}
\usage{
register.firm(
  name,
  id = NA,
  legal_form = NA,
  sector = NA,
  sector_classif = NULL,
  revenues = NA,
  capitalisation = NA,
  management = NA,
  ownership = NA,
  shares = NA,
  currency = NA
)
}
\arguments{
\item{name}{Name of the firm}

\item{id}{Provide an ID code for the firm. Defaults to \code{NA}}

\item{legal_form}{Legal form of the firm (e.g., LLP, Inc, GmbH, Private, etc.)}

\item{sector}{Sector in which the firm operates (its values depend on the value of \code{sector_classif})}

\item{sector_classif}{Which standard sector classification (if any) to be used. Possible values are
- \code{NACE} for the Statistical Classification of Economic Activities in the European Community or 'Nomenclature statistique des Activités économiques dans la Communauté Européenne', revision 2;
- \code{NA} for a custom classification (default if anything is provided);
- \code{NULL} for no classification (default if nothing is provided).}

\item{revenues}{Yearly revenues}

\item{capitalisation}{Firm's capitalisation}

\item{management}{Names of the members of the board}

\item{ownership}{Names of the owner(s)}

\item{shares}{Share owned by (each of) the owner(s)}

\item{currency}{Currency in which the capitalisation and revenues are expressed (defaults to `USD`)}
}
\value{
An object of the S4 class \code{firm} containing several fields, only the first one of which is mandatory:
\item{name}{Name of the firm}
\item{id}{ID of the firm, usually the ticker}
\item{legal_form}{Legal form of the firm}
\item{sector}{Sector in which the firm operates}
\item{revenues}{Yearly revenues}
\item{capitalisation}{Capitalisation}
\item{management}{Members of the board}
\item{ownership}{Owner(s)}
\item{shares}{Share owned by (each of) the owner(s)}
\item{currency}{Currency}
}
\description{
Function to create a \code{firm} (legal person)
}
\examples{

# Registering Apple manually
AAPL <- register.firm(name = 'Apple', id = 'AAPL', legal_form = 'GmbH',
                      revenues = 81665400000, capitalisation = 2755039000000,
                      management = my_vector <- c("Timothy D. Cook",
                                                  "Luca Maestri",
                                                  "Jeffrey E. Williams",
                                                  "Katherine L. Adams",
                                                  "Deirdre O'Brien",
                                                  "Chris Kondo",
                                                  "James Wilson",
                                                  "Mary Demby",
                                                  "Nancy Paxton",
                                                  "Greg Joswiak"),
                      ownership = c('Vanguard Total Stock Market Index Fund',
                      'Vanguard 500 Index Fund',
                      'Fidelity 500 Index Fund',
                      'SPDR S&P 500 ETF Trust',
                      'iShares Core S&P 500 ETF',
                      'Invesco ETF Tr-Invesco QQQ Tr, Series 1 ETF',
                      'Vanguard Growth Index Fund',
                      'Vanguard Institutional Index Fund-Institutional Index Fund',
                      'Vanguard Information Technology Index Fund',
                      'Select Sector SPDR Fund-Technology'),
                      shares = c(0.0290, 0.0218, 0.0104, 0.0102, 0.0084,
                                 0.0082, 0.0081, 0.0066, 0.0043, 0.0039),
                      currency = 'USD')

# Registering a coal-mining company indicating the sector using `NACE` codes, without ID
set.seed(123456789)
firm_coalmining <- register.firm(
  name = 'A coal-mining firm',
  legal_form = 'Private',
  sector = 'B.05',
  sector_classif = 'NACE'
)

# Getting creative: Register a firm with coded owners and managers
set.seed(123456789)
firm_coded <- register.firm(
  name = 'Coded firm',
  revenues = sample(seq(1:100)/10, 1)*10^sample(1:5, 1),
  capitalisation = sample(seq(1:100)/10, 1)*10^sample(2:7, 1),
  management = c('Board Member', 'CEO', 'CTO', 'Activist investor'),
  ownership = c('State', 'Foreign investors'),
  shares = c(51, 49),
  currency = 'EUR'
)

}
\seealso{
\link{find.firm}
}
\author{
\enc{Telarico, Fabio Ashtar}{Fabio Ashtar Telarico}
}
